<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Front extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	 public function __construct()
	 {

		parent::__construct();

        $this->load->helper('captcha');

        $this->dbname = $this->db->database;
		$this->data['settings'] = $this->custom->getSettings();
		
		// User login status 
        $this->isUserLoggedIn = $this->session->userdata('isUserLoggedIn');
		$this->data['isUserLoggedIn'] = $this->isUserLoggedIn;
		
		if(!empty($this->isUserLoggedIn)){
			if($this->session->userdata('userType')=='1'){
                $this->data['myaccountLink'] = base_url('agency/dashboard');
            }else{
                $this->data['myaccountLink'] = base_url('candidate/dashboard');
            }
		}

        $total_post_jobc = $this->custom->query("SELECT u_id,p_id,count(u_id) as tot FROM `post_job` group by u_id;");
        $postarrc = array();
        if($total_post_jobc){
           
            foreach($total_post_jobc as $pjc){
                $postarrc[$pjc->u_id] = $pjc->tot;
            }
        }

        $this->data['postarrc'] = $postarrc;

        $this->data['lang'] = $this->session->userdata('site_lang');

        $qualification = $this->config->item('qualification'); 	$this->data['qualification'] = $qualification;
		
       
        
	  }
	  

	public function index()
	{
		
		/* if($this->isUserLoggedIn){ 
            redirect('sadmin/account'); 
        }else{ 
            redirect('sadmin/login'); 
        }  */
		
		//$this->session->set_userdata('site_lang', "english");
        $this->data['countries'] = $this->custom->get_data('country');
        $this->data['categories'] = $this->custom->get_where('jobspecialization',array('js_featured'=>1));
        
        $total_post_job = $this->custom->query("SELECT js_id,p_id,count(js_id) as tot FROM `post_job` group by js_id;");
       
        $postarr = array();
        if($total_post_job){
            
            foreach($total_post_job as $pj){
                $postarr[$pj->js_id] = $pj->tot;
            }
        }

        $this->data['postarr'] = $postarr ; 
        $this->data['featured_job'] = $this->custom->query("SELECT pj.*,js.js_title,js.js_title_hindi,c.cname,u.u_a_comp_name,u.u_a_ra_id,u.u_a_licence_no FROM `post_job` pj,jobspecialization js, country c, users u where pj.js_id=js.js and pj.u_id=u.u_id and pj.p_country=c.id and pj.p_featured='1' ");
        $this->data['agencylist'] = $this->custom->get_where('users',array('u_usertype'=>1,'u_featured'=>1));
		$this->load->front_view('index',$this->data,1);
	}
	
	
	 public function switchLang($language = "") {
        
        $language = ($language != "") ? $language : "english";
        $this->session->set_userdata('site_lang', $language);
        
        redirect($_SERVER['HTTP_REFERER']);
        
    } 
	

    public function signup()
	{
		
		/* if($this->isUserLoggedIn){ 
            redirect('sadmin/account'); 
        }else{ 
            redirect('sadmin/login'); 
        }  */
		
		$this->session->set_userdata('site_lang', "english");
		$this->load->front_view('signup',$this->data);
	}


    public function services()
	{
		
		$id = $this->uri->segment(3);
        $this->session->set_userdata('site_lang', "english");

       
        $this->load->front_view('services',$this->data);
	}

    public function about()
	{
		
		$id = $this->uri->segment(3);
        $this->session->set_userdata('site_lang', "english");

       
        $this->load->front_view('about',$this->data);
	}
    public function disclaimer()
	{
		
		$id = $this->uri->segment(3);
        $this->data['disclaimer'] = $this->data['settings'][0]->s_disclaimer;
        $this->session->set_userdata('site_lang', "english");

       
        $this->load->front_view('disclaimer',$this->data);
	}
    public function terms_conditions()
	{
		
		$id = $this->uri->segment(3);
        $this->data['terms_conditions'] = $this->data['settings'][0]->s_terms_conditions;
        $this->session->set_userdata('site_lang', "english");

       
        $this->load->front_view('terms_conditions',$this->data);
	}
    public function privacy_policy()
	{
		
		$id = $this->uri->segment(3);
        $this->data['privacy_policy'] = $this->data['settings'][0]->s_privacy_policy;
        $this->session->set_userdata('site_lang', "english");

       
        $this->load->front_view('privacy_policy',$this->data);
	}

    public function contact()
	{
		
		$id = $this->uri->segment(3);
        $this->session->set_userdata('site_lang', "english");

       
        $this->load->front_view('contact',$this->data);
	}



    public function jobs_by_category()
	{
		
		$id = $this->uri->segment(3);
        $this->session->set_userdata('site_lang', "english");

        

        $this->data['id'] = $id;
        $this->data['countries'] = $this->custom->get_data('country');
        $this->data['categories'] = $this->custom->get_data('jobspecialization');

        
        $this->data['jobslist'] = $this->custom->query("Select pj.*,c.cname,u.u_a_comp_name,u.u_a_company_logo from post_job pj, country c, users u where pj.p_country=c.id and pj.u_id=u.u_id and pj.js_id='".$id."'");

        
        
		$this->load->front_view('browse_jobs_by_category',$this->data);
	}

    public function jobs_by_categories()
	{
		
		$id = $this->uri->segment(3);
        $this->session->set_userdata('site_lang', "english");

        $total_post_job = $this->custom->query("SELECT js_id,p_id,count(js_id) as tot FROM `post_job` group by js_id;");
       
        if($total_post_job){
            $postarr = array();
            foreach($total_post_job as $pj){
                $postarr[$pj->js_id] = $pj->tot;
            }
        }

        $this->data['postarr'] = $postarr ; 
        $this->data['categories'] = $this->custom->get_data('jobspecialization');

        $this->load->front_view('categories',$this->data);
	}

    public function jobs_by_countries()
	{
		
		$id = $this->uri->segment(3);
        $this->session->set_userdata('site_lang', "english");

        $total_post_job = $this->custom->query("SELECT p_country,p_id,count(p_country) as tot FROM `post_job` group by p_country;");
       
        if($total_post_job){
            $postarr = array();
            foreach($total_post_job as $pj){
                $postarr[$pj->p_country] = $pj->tot;
            }
        }

        $this->data['postarr'] = $postarr ; 
        $this->data['countries'] = $this->custom->get_data('country');

        $this->load->front_view('countries',$this->data);
	}

    public function latest_jobs()
	{
		
		$id = $this->uri->segment(3);
        $this->session->set_userdata('site_lang', "english");

        $this->data['latest_jobs'] = $this->custom->query("select pj.*,c.cname,u.u_a_comp_name,u.u_a_company_logo,u.u_a_ra_id from post_job pj, country c, users u where pj.p_country=c.id and pj.u_id=u.u_id order by p_id desc limit 0,15");
       
        $this->load->front_view('latest_jobs',$this->data);
	}

    public function job_detail()
	{
		
		$id = $this->uri->segment(3);
        $uid = $this->session->userdata('userId');
        $this->session->set_userdata('site_lang', "english");

        $this->data['id'] = $id;
        $this->data['jobdetail'] = $this->custom->query("Select pj.*,c.cname,u.u_a_comp_name,u.u_a_company_logo,u.u_a_ra_id,u.u_a_licence_no from post_job pj, country c, users u where pj.p_country=c.id and pj.u_id=u.u_id and pj.p_id='".$id."'");

        $this->data['totreviews'] = $this->custom->query("Select count(r_id) as tot from reviews where pj_id='".$id."'");
        
        $this->data['appliedjob'] = $this->custom->get_where('stu_saved_applied_jobs',array('p_id'=>$id,'u_id'=>$uid));
        $this->data['relatedjobs'] = $this->custom->query("Select pj.*,c.cname,u.u_a_comp_name,u.u_a_company_logo,u.u_a_ra_id,js_title,u.u_a_licence_no from post_job pj, country c, users u,jobspecialization js where pj.p_country=c.id and pj.js_id=js.js and  pj.u_id=u.u_id ");

        $this->data['applied'] = 0;
        if(count($this->data['appliedjob'])>0){
            $this->data['applied'] = 1;
        }

        if(!empty($this->isUserLoggedIn)){
			if($this->session->userdata('userType')=='2'){
                $this->data['applylink'] = base_url('front/apply_job/'.$this->data['jobdetail'][0]->p_id);
                $this->data['savelink'] = base_url('front/save_job/'.$this->data['jobdetail'][0]->p_id);
            }else{
                $this->data['applylink'] = base_url('agency/dashboard');
                $this->data['savelink'] = base_url('agency/dashboard');
            }
		}else{
            $this->data['applylink'] = base_url('candidate/dashboard');
            $this->data['savelink'] = base_url('candidate/dashboard');
        }


        $this->data['captcha'] =getCaptcha();

        
		$this->load->front_view('job_detail',$this->data);
	}


    
    public function search_result()
	{
		
		echo $id3 = $this->uri->segment(3);
		echo $id4 = $this->uri->segment(4);


         $searchkey = $this->input->get('searchkey');
         $this->data['searchkey'] = $searchkey;

         $country = $this->input->get('search_country');
         $this->data['country'] = $country;

         $category = $this->input->get('search_category');
         $this->data['category'] = $category;

        $searchqry ='';

        if(!empty($searchkey)){
            $searchqry .=" and pj.p_job_title like '%".$searchkey."%' ";
        }

        if(!empty($country)){
            $searchqry .=" and pj.p_country = '".$country."' ";
        }

        if(!empty($category)){
            $searchqry .=" and pj.js_id = '".$category."' ";
        }

        $this->data['searchlist'] = $this->custom->query("Select pj.*,c.cname,u.u_a_comp_name,u.u_a_company_logo,u.u_a_ra_id from post_job pj, country c, users u where pj.p_country=c.id and pj.u_id=u.u_id $searchqry ");

        $this->data['countries'] = $this->custom->get_data('country');
        $this->data['categories'] = $this->custom->get_data('jobspecialization');
        
		$this->load->front_view('search_result',$this->data);
	}

    public function apply_job()
	{
		
		$id = $this->uri->segment(3);
		$uid = $this->session->userdata('userId');
        $this->session->set_userdata('site_lang', "english");
        $table = "stu_saved_applied_jobs";


        if($this->input->post('applyjob')){
			
           $jobdet =  $this->custom->get_where('post_job',array('p_id'=>$id));

			$this->form_validation->set_rules('sj_applied_desc', 'Your Self', 'required'); 
            
           $rowData = cleanArray($this->input->post());
		   
          
		   $rowData['p_id']= $id; 
		   $rowData['u_id']= $uid; 
		   $rowData['agency_id']= $jobdet[0]->u_id; 
		   $rowData['sj_status']= 1; 
		   $rowData['sj_applied_date'] = date("Y-m-d H:i:s"); 
		   unset($rowData['applyjob']);
		   unset($rowData['_wysihtml5_mode']);

          
           if(insertQry($table,$rowData)){
               redirect('front/apply_job/'.$id); 
            }else{
                foreach($rowData as $ky => $vl){
                    $this->data[$ky] = $vl;
                }
            }
		}else{
			getTableInfo($this->dbname,$table);
		}



        if(!empty($this->isUserLoggedIn)){
			if($this->session->userdata('userType')=='2'){
                $this->data['applylink'] = base_url('front/applyjob');
            }else{
                $this->data['applylink'] = base_url('agency/dashboard');
            }
		}else{
            $this->data['applylink'] = base_url('candidate/dashboard');
        }

        $this->data['jobdetail'] = $this->custom->get_where('post_job',array('p_id'=>$id));
		$this->load->front_view('apply_job',$this->data);
	}


    public function save_job()
	{
		
		$id = $this->uri->segment(3);
		$uid = $this->session->userdata('userId');
        $this->session->set_userdata('site_lang', "english");
        $table = "stu_saved_applied_jobs";
          
		   $rowData['p_id']= $id; 
		   $rowData['u_id']= $uid; 
		   $rowData['sj_status']= 0; 
		   $rowData['sj_saved_date'] = date("Y-m-d H:i:s"); 
          
           if(insertQry($table,$rowData)){
                redirect('front/job_detail/'.$id); 
           }
		
	}

	public function login(){ 
        $data = array(); 
         
         
        // If login request submitted 
        if($this->input->post('loginSubmit')){ 
            $this->form_validation->set_rules('username', 'Email', 'required'); 
            $this->form_validation->set_rules('password', 'password', 'required'); 
             
            if($this->form_validation->run() == true){ 
                $con = array( 
                    'returnType' => 'single', 
                    'conditions' => array( 
                        'u_userid'=> $this->input->post('username'), 
                        'u_pass' => md5($this->input->post('password')), 
                        'u_status' => 1 
                    ) 
                ); 
                $checkLogin = $this->custom->getRows('users',$con);
				if($checkLogin){ 
					if($checkLogin['u_userid']==$this->input->post('username') && $checkLogin['u_pass']==md5($this->input->post('password')))
					{
						$this->session->set_userdata('isUserLoggedIn', TRUE); 
						$this->session->set_userdata('userId', $checkLogin['u_id']); 
                        
						redirect('sadmin/account'); 
					}else{
						$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">Wrong Username or password, please try again.</div>');
						
					}
                }else{ 
                    $this->session->set_flashdata('error_msg', '<div class="alert alert-danger">Wrong Username or password, please try again.</div>');
                } 
            }else{ 
				$this->session->set_flashdata('error_msg', '<div class="alert alert-warning">Please fill all the mandatory fields.</div>');
                
            } 
        } 
         
        // Load view 
        $this->load->admin_view('login', $this->data, 1); 
        
    } 
	
	public function registration(){ 
        $data = $userData = array(); 
         
        // If registration request is submitted 
        if($this->input->post('signupSubmit')){ 
            $this->form_validation->set_rules('first_name', 'First Name', 'required'); 
            $this->form_validation->set_rules('last_name', 'Last Name', 'required'); 
            $this->form_validation->set_rules('email', 'Email', 'required|valid_email|callback_email_check'); 
            $this->form_validation->set_rules('password', 'password', 'required'); 
            $this->form_validation->set_rules('conf_password', 'confirm password', 'required|matches[password]'); 
 
            $userData = array( 
                'first_name' => strip_tags($this->input->post('first_name')), 
                'last_name' => strip_tags($this->input->post('last_name')), 
                'email' => strip_tags($this->input->post('email')), 
                'password' => md5($this->input->post('password')), 
                'gender' => $this->input->post('gender'), 
                'phone' => strip_tags($this->input->post('phone')) 
            ); 
 
            if($this->form_validation->run() == true){ 
                $insert = $this->custom->insert($userData); 
                if($insert){ 
                    $this->session->set_userdata('success_msg', 'Your account registration has been successful. Please login to your account.'); 
                    redirect('sadmin/login'); 
                }else{ 
                    $data['error_msg'] = 'Some problems occured, please try again.'; 
                } 
            }else{ 
                $data['error_msg'] = 'Please fill all the mandatory fields.'; 
            } 
        } 
         
        // Posted data 
        $data['user'] = $userData; 
         
        // Load view 
        $this->load->view('elements/header', $data); 
        $this->load->view('registration', $data); 
        $this->load->view('elements/footer'); 
    } 
     
    public function logout(){ 
        $this->session->unset_userdata('isUserLoggedIn'); 
        $this->session->unset_userdata('userId'); 
        $this->session->sess_destroy(); 
        redirect('sadmin/login'); 
    } 
     
     
    // Existing email check during validation 
    public function email_check($str){ 
        $con = array( 
            'returnType' => 'count', 
            'conditions' => array( 
                'email' => $str 
            ) 
        ); 
        $checkEmail = $this->custom->getRows($con); 
        if($checkEmail > 0){ 
            $this->form_validation->set_message('email_check', 'The given email already exists.'); 
            return FALSE; 
        }else{ 
            return TRUE; 
        } 
    } 


    public function verify_request() {
		
		if($this->input->post('submitverify')){
			
			$this->form_validation->set_rules('v_name', 'Student Name', 'required'); 
            $this->form_validation->set_rules('v_contactno', 'Student Contact No.', 'required'); 
        
           $rowData = cleanArray($this->input->post());
		   
		   $rowData['modified']= date("Y-m-d H:i:s"); 
		   unset($rowData['submitverify']);
		   unset($rowData['base']);
		   
		   if(insertQry('verify',$rowData)){
				
                $v_id = $this->db->insert_id();

                /* ra license upload */
                $upload_param['filename'] = 'v_file';
                $upload_param['path'] = 'verify';
                $upload_param['types'] = 'jpeg|jpg|png|pdf|doc|docx';
                $upload_param['size'] = '1024';
                $upload_param['width'] = '0';
                $upload_param['height'] = '0';
                $upload_param['table'] = 'verify';
                $upload_param['field'] = 'v_file';
                $upload_param['pkfield'] = 'v_id';
                $upload_param['pkval'] = $v_id;
                
                $filestaus = fileupload($upload_param);
                if($filestaus['error']==1){
                    $this->session->set_flashdata('error_msg', '<div class="alert alert-danger">File format not supported.</div>');
                }else{
                    $this->session->set_flashdata('error_msg', '<div class="alert alert-success">File has been uploaded.</div>');
                }
                
                    ?>
                    <script>
                        var base="<?php echo base_url(); ?>";
                        alert("Your request has been submitted. Team will contact you soon.");
                    
                    window.location.replace(base);
                    </script>
                    <?php
			 
		   }
		}

       


	}



    public function ajax_verify_request() {
		
		$stu_name = $this->input->post('stu_name');
		$stu_contactno = $this->input->post('stu_contactno');
		$created = date('Y-m-d H:i:s');
		$v_status = 0;

		$verify = $this->custom->get_where('verify',array('v_contactno'=>$stu_contactno));
       
		if(count($verify)==0){
			$inarr = array(
				'v_name'=>$stu_name,
				'v_contactno'=>$stu_contactno,
				'v_status'=>$v_status,
				
				'created'=>$created,
				'modified'=>$created,
	
			);
	
			$insert = $this->custom->insert('verify',$inarr); 
			if($insert){ 
				echo 1;
			}else{
				echo 0;
			}
		}else{
			echo 2;
		}


       


	}


    public function ajax_save_review() {
		
		$stu_review = $this->input->post('stu_review');
		$pjid = $this->input->post('pjid');
        $created = date('Y-m-d H:i:s');
		$r_status = 1;

        if(!empty($this->session->userdata('userId'))){
            $uid = $this->session->userdata('userId');

            $review = $this->custom->get_where('reviews',array('u_id'=>$uid,'pj_id'=>$pjid));
       
            if(count($review)==0){
                $inarr = array(
                    'r_review'=>$stu_review,
                    'pj_id'=>$pjid,
                    'u_id'=>$uid,
                    'r_status'=>$r_status,
                    
                    'created'=>$created,
                    'modified'=>$created,
        
                );
        
                $insert = $this->custom->insert('reviews',$inarr); 
                if($insert){ 
                    echo 1;
                }else{
                    echo 0;
                }
            }else{
                echo 2;
            }

        }else{
            echo 3;
        }
		

		


       
	}

    public function ajax_reviews() {
		
        $pid = $this->input->post('pid');
        $uid = $this->session->userdata('userId');
        $created = date('Y-m-d H:i:s');
        $r_status = 1;

        $html = '';

        $reviews = $this->custom->get_where('reviews',array('pj_id'=>$pid,'r_status'=>1));
       
        if(count($reviews)>0){
            if($reviews){
                $i=0;
                foreach($reviews as $review){
                    if($i==0){
                        $html .= $pid.'[s]<tr><td style="">'.$review->r_review.'</td></tr>'; 
                    }else{
                        $html .= '<tr><td>'.$review->r_review.'</td></tr>';
                    }
                    $i++;
                }
            }

            
        }else{
             $html .= $pid.'[s]<tr><td>There are no Reviews</td></tr>';
        }
        echo $html;
    }

    public function ajax_getintouch() {
		
		$name = $this->input->post('name');
		$email = $this->input->post('email');
		$msg = $this->input->post('msg');
		$pj_id = $this->input->post('pj_id');
		$captcha = $this->input->post('captcha');
		$created = date('Y-m-d H:i:s');
		$v_status = 0;


        // First, delete old captchas
        $expiration = time() - 7200; // Two hour limit
        $this->db->where('captcha_time < ', $expiration)
                ->delete('captcha');

        // Then see if a captcha exists:
        $sql = 'SELECT COUNT(*) AS count FROM captcha WHERE word = ? AND ip_address = ? AND captcha_time > ?';
        $binds = array($captcha, $this->input->ip_address(), $expiration);
        $query = $this->db->query($sql, $binds);
        $row = $query->row();

        if ($row->count == 0)
        {
            echo 3; 
        }else{


                $verify = $this->custom->get_where('getintouch',array('g_email'=>$email));
            
                if(count($verify)==0){
                    $inarr = array(
                        'g_name'=>$name,
                        'g_email'=>$email,
                        'g_message'=>$msg,
                        'pj_id'=>$pj_id,
                        'g_status'=>0,
                        
                        'created'=>$created,
                        'modified'=>$created,
            
                    );
            
                    $insert = $this->custom->insert('getintouch',$inarr); 
                    if($insert){ 
                        echo 1;
                    }else{
                        echo 0;
                    }
                }else{
                    echo 2;
                }
        }


		
	}

	
	public function account()
	{
		$this->load->admin_view('dashboard',$this->data);
	}
}