<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Sadmin extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	 public function __construct()
	 {

		parent::__construct();
		
		$this->dbname = $this->db->database;
		$this->data['settings'] = $this->custom->getSettings();
		$this->data['adminpath'] = $this->data['settings'][0]->s_adminpath;
		
		// User login status 
        $this->isUserLoggedIn = $this->session->userdata('isUserLoggedIn');
		
		$this->data['link'] = $this->uri->segment(2);
		$this->data['action'] = $this->uri->segment(3);
		
		if(empty($this->isUserLoggedIn)){
			if($this->uri->segment('2')!='login' && $this->uri->segment('2')!='forgotpassword' && $this->uri->segment('2')!='newpassword'){
				redirect('sadmin/login'); 
			}
		}else{
			$this->userdet = $this->custom->get_where('users',array('u_id'=>$this->session->userData('userId')));
			$this->data['userdet'] = $this->userdet;
			
			
		}
		
		$this->load->library('csvimport');
        $this->load->helper('file');

		
		
		$appstatus = $this->config->item('appstatus'); 	$this->data['appstatus'] = $appstatus;
		$utype = $this->config->item('utype'); 	$this->data['utype'] = $utype;
		$department = $this->config->item('department'); 	$this->data['department'] = $department;
		$stream = $this->config->item('stream'); 	$this->data['stream'] = $stream;
		
		$gender = $this->config->item('gender'); 	$this->data['gender'] = $gender;
		$categorytype = $this->config->item('categorytype'); 	$this->data['categorytype'] = $categorytype;
		$featured = $this->config->item('featured'); 	$this->data['featured'] = $featured;
		$status = $this->config->item('status'); 	$this->data['status'] = $status;
		$qualification = $this->config->item('qualification'); 	$this->data['qualification'] = $qualification;
	  }
	  

	 
	public function index()
	{
		
		if($this->isUserLoggedIn){ 
            redirect('sadmin/dashboard'); 
        }else{ 
            redirect('sadmin/login'); 
        } 
		
	}
	
	public function login(){ 
        $data = array(); 
         
         
        // If login request submitted 
        if($this->input->post('loginSubmit')){ 
            $this->form_validation->set_rules('username', 'Email', 'required'); 
            $this->form_validation->set_rules('password', 'password', 'required'); 
             
            if($this->form_validation->run() == true){ 
                $con = array( 
                    'returnType' => 'single', 
                    'conditions' => array( 
                        'u_userid'=> $this->input->post('username'), 
                        'u_pass' => $this->input->post('password'), 
                        'u_status' => 1, 
                    ) 
                ); 
                $checkLogin = $this->custom->getRows('users',$con);
				if($checkLogin){ 
					if($checkLogin['u_userid']==$this->input->post('username') && $checkLogin['u_pass']==$this->input->post('password'))
					{
						$this->session->set_userdata('isUserLoggedIn', TRUE); 
						$this->session->set_userdata('userId', $checkLogin['u_id']); 
						redirect('sadmin/dashboard'); 
					}else{
						$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">Wrong Username or password, please try again.</div>');
						
					}
                }else{ 
                    $this->session->set_flashdata('error_msg', '<div class="alert alert-danger">Wrong Username or password, please try again.</div>');
                } 
            }else{ 
				$this->session->set_flashdata('error_msg', '<div class="alert alert-warning">Please fill all the mandatory fields.</div>');
                
            } 
        } 
         
        // Load view 
        $this->load->admin_view('login', $this->data, 1); 
        
    } 

	public function forgotpassword(){ 
        $data = array(); 
         
         
        // If login request submitted 
        if($this->input->post('forgotSubmit')){ 
            $this->form_validation->set_rules('txtemail', 'Email', 'required'); 
             
            if($this->form_validation->run() == true){ 
               
				
				$con = array( 
                    'returnType' => 'single', 
                    'conditions' => array( 
                        'u_email'=> $this->input->post('txtemail'), 
                        'u_status' => 1, 
                    ) 
                ); 
                $checkLogin = $this->custom->getRows('users',$con);
				if($checkLogin){ 
					if($checkLogin['u_email']==$this->input->post('txtemail'))
					{
						$mdemail = md5('immi'.$checkLogin['u_email']);
						$email = $checkLogin['u_email'];

						$link = base_url('sadmin/newpassword/'.$mdemail.'/'.$email);
						$to_email = $checkLogin['u_email'];
						$from_email = 'info@bces.in';
						$from_name = 'IT Team';
						$subject = 'Reset you password';
						$email_template = 'forgot_mail';
						$message_data = array('name' => $checkLogin['u_fname'].' '.$checkLogin['u_lname'],'link' => $link);

						if($this->send_mail($to_email,$from_email, $from_name,$subject,$email_template,$message_data)){
							$this->session->set_flashdata("email_sent","Email sent successfully."); 
						}else{
							$this->session->set_flashdata("email_sent","Error in sending Email."); 
						}
						redirect('sadmin/login'); 
					}else{
						$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">Wrong Email Id, please try again.</div>');
						
					}
                }else{ 
                    $this->session->set_flashdata('error_msg', '<div class="alert alert-danger">Wrong Email Id, please try again.</div>');
                } 
            }else{ 
				$this->session->set_flashdata('error_msg', '<div class="alert alert-warning">Please fill all the mandatory fields.</div>');
                
            } 
        } 
         
        // Load view 
        $this->load->admin_view('forgotpassword', $this->data, 1); 
        
    }
	
	public function newpassword(){ 
        $data = array(); 
		$qcode = $this->uri->segment(3);
		$qemail = $this->uri->segment(4);

		
		if($qcode==md5('immi'.$qemail)){
			if($this->input->post('newSubmit')){ 
				$this->form_validation->set_rules('newpass', 'Password', 'required'); 
				 
				if($this->form_validation->run() == true){ 
				   
					
					$con = array( 
						'returnType' => 'single', 
						'conditions' => array( 
							'u_email'=> $qemail, 
							'u_status' => 1, 
						) 
					); 
					$checkLogin = $this->custom->getRows('users',$con);
					if($checkLogin){ 
						if($checkLogin['u_email']==$qemail)
						{
							if(updateQry('users',array('u_pass'=>$this->input->post('newpass')),array('u_id'=>$checkLogin['u_id']))){
								$this->session->set_flashdata('error_msg', '<div class="alert alert-success">New Password has been set.</div>');
								redirect('sadmin/login','refresh'); 
							 }else{
								$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">Something went wrong, please try again.</div>');
							 }
	
							if($this->send_mail($to_email,$from_email, $from_name,$subject,$email_template,$message_data)){
								$this->session->set_flashdata("email_sent","Email sent successfully."); 
							}else{
								$this->session->set_flashdata("email_sent","Error in sending Email."); 
							}
							
						}else{
							$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">Wrong Email Id, please try again.</div>');
							
						}
					}else{ 
						$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">Wrong Email Id, please try again.</div>');
					} 
				}else{ 
					$this->session->set_flashdata('error_msg', '<div class="alert alert-warning">Please fill all the mandatory fields.</div>');
					
				} 
			}

			// Load view 
			$this->load->admin_view('newpassword', $this->data, 1); 
		}else{

			$this->session->set_flashdata('error_msg', '<div class="alert alert-warning">Something went wrong. Please try again.</div>');
			redirect('sadmin/login','refresh'); 
		}
         
        
        
    }
	
	public function registration(){ 
        $data = $userData = array(); 
         
        // If registration request is submitted 
        if($this->input->post('signupSubmit')){ 
            $this->form_validation->set_rules('first_name', 'First Name', 'required'); 
            $this->form_validation->set_rules('last_name', 'Last Name', 'required'); 
            $this->form_validation->set_rules('email', 'Email', 'required|valid_email|callback_email_check'); 
            $this->form_validation->set_rules('password', 'password', 'required'); 
            $this->form_validation->set_rules('conf_password', 'confirm password', 'required|matches[password]'); 
 
            $userData = array( 
                'first_name' => strip_tags($this->input->post('first_name')), 
                'last_name' => strip_tags($this->input->post('last_name')), 
                'email' => strip_tags($this->input->post('email')), 
                'password' => $this->input->post('password'), 
                'gender' => $this->input->post('gender'), 
                'phone' => strip_tags($this->input->post('phone')) 
            ); 
 
            if($this->form_validation->run() == true){ 
                $insert = $this->custom->insert($userData); 
                if($insert){ 
                    $this->session->set_userdata('success_msg', 'Your account registration has been successful. Please login to your account.'); 
                    redirect('sadmin/login'); 
                }else{ 
                    $data['error_msg'] = 'Some problems occured, please try again.'; 
                } 
            }else{ 
                $data['error_msg'] = 'Please fill all the mandatory fields.'; 
            } 
        } 
         
        // Posted data 
        $data['user'] = $userData; 
         
        // Load view 
        $this->load->view('elements/header', $data); 
        $this->load->view('registration', $data); 
        $this->load->view('elements/footer'); 
    } 
     
    public function logout(){ 
        $this->session->unset_userdata('isUserLoggedIn'); 
        $this->session->unset_userdata('userId'); 
        $this->session->sess_destroy(); 
        redirect('sadmin/login'); 
    } 
     
     
    // Existing email check during validation 
    public function email_check($str){ 
        $con = array( 
            'returnType' => 'count', 
            'conditions' => array( 
                'email' => $str 
            ) 
        ); 
        $checkEmail = $this->custom->getRows($con); 
        if($checkEmail > 0){ 
            $this->form_validation->set_message('email_check', 'The given email already exists.'); 
            return FALSE; 
        }else{ 
            return TRUE; 
        } 
    } 
	
	public function dashboard()
	{
		$table = 'leads';
		$where ='';

		if($this->userdet[0]->u_role==3){
			$leads = $this->custom->query("select * from ".$table." where l_id!=0 ".$where);
		}elseif($this->userdet[0]->u_role==1){
			$leads = $this->custom->query("select * from ".$table." where  (l_by='".$this->session->userdata('userId')."' or l_assign='".$this->session->userdata('userId')."') ".$where);
		}elseif($this->userdet[0]->u_role==4){
			

			if(!empty($this->userdet[0]->u_assgned_agent)){
                                               
				$pos = strpos($this->userdet[0]->u_assgned_agent, ',');
				
				if ($pos === false) {
					$leads = $this->custom->query("select * from ".$table." where  (l_by='".$this->userdet[0]->u_assgned_agent."' ) ".$where);
				} else {
					$leads = $this->custom->query("select * from ".$table." where  (l_by in (".$this->userdet[0]->u_assgned_agent.") ) ".$where);
				}
			}

		}else{
			/* $leads = $this->custom->get_where($table,array('l_by'=>$this->session->userdata('userId'))); */
			$leads = $this->custom->query("select * from ".$table." where l_by='".$this->session->userdata('userId')."' ".$where);
		}
		/* $this->data['leads'] = $leads; */
		$totapp =0;
		$totpending =0;
		$totcondapproved =0;
		$totapproved =0;
		$totrejected =0;
		$totvisapending =0;
		$totprevisa =0;
		$totdeposit =0;
		$totnopay =0;
		$totvisapproved =0;
		$totvisarejected =0;
		if($leads){
			foreach($leads as $lead){
				$totapp ++;
				if($lead->l_app_status==0){
					$totpending ++;
				}elseif($lead->l_app_status==1){
					$totapproved ++;
					if($lead->l_visa_status==0){
						$totvisapending ++;
					}elseif($lead->l_visa_status==1){
						$totvisapproved ++;
					}else{
						$totvisarejected ++;
					}
				}elseif($lead->l_app_status==2){
					$totrejected ++;
				}else{
					$totcondapproved ++;
				}

				if($lead->l_payment==1){
					$totprevisa++;
				}elseif($lead->l_payment==2){
					$totdeposit++;
				}else{
					$totnopay++;
				}

			}
			


		}

		$this->data['totapp'] =	$totapp;
		$this->data['totpending'] =	$totpending;
		$this->data['totcondapproved'] =	$totcondapproved;
		$this->data['totapproved'] =	$totapproved;
		$this->data['totrejected'] =	$totrejected;
		$this->data['totvisapending'] =	$totvisapending;
		$this->data['totprevisa'] =	$totprevisa;
		$this->data['totdeposit'] =	$totdeposit;
		$this->data['totnopay'] =	$totnopay;
		$this->data['totvisapproved'] =	$totvisapproved;
		$this->data['totvisarejected'] =	$totvisarejected;

		$agents = $this->custom->query("select * from users where u_role=2 ");

		$agent_name = '';
		
		$agentdata = array();
		if($agents){
			foreach($agents as $agent){
				$agent_name  = $agent->u_fname.'  '.$agent->u_lname;
				$agent_totapp =0;
				$agent_totpending =0;
				$agent_totcondapproved =0;
				$agent_totapproved =0;
				$agent_totrejected =0;
				$agent_totvisapending =0;
				$agent_totprevisa =0;
				$agent_totdeposit =0;
				$agent_totnopay =0;
				$agent_totvisapproved =0;
				$agent_totvisarejected =0;
				if($leads){
					foreach($leads as $lead){
						
						if($agent->u_id==$lead->l_by){
							$agent_totapp ++;
							if($lead->l_app_status==0){
								$agent_totpending ++;
							}elseif($lead->l_app_status==1){
								$agent_totapproved ++;
								if($lead->l_visa_status==0){
									$agent_totvisapending ++;
								}elseif($lead->l_visa_status==1){
									$agent_totvisapproved ++;
								}else{
									$agent_totvisarejected ++;
								}
							}elseif($lead->l_app_status==2){
								$agent_totrejected ++;
							}else{
								$agent_totcondapproved ++;
							}

							if($lead->l_payment==1){
								$agent_totprevisa++;
							}elseif($lead->l_payment==2){
								$agent_totdeposit++;
							}else{
								$agent_totnopay++;
							}
						}



					}
					$agentdata[$agent_name]['totapp'] =	$agent_totapp;
					$agentdata[$agent_name]['totpending'] =	$agent_totpending;
					$agentdata[$agent_name]['totcondapproved'] =	$agent_totcondapproved;
					$agentdata[$agent_name]['totapproved'] =	$agent_totapproved;
					$agentdata[$agent_name]['totrejected'] =	$agent_totrejected;
					$agentdata[$agent_name]['totvisapending'] =	$agent_totvisapending;
					$agentdata[$agent_name]['totprevisa'] =	$agent_totprevisa;
					$agentdata[$agent_name]['totdeposit'] =	$agent_totdeposit;
					$agentdata[$agent_name]['totnopay'] =	$agent_totnopay;
					$agentdata[$agent_name]['totvisapproved'] =	$agent_totvisapproved;
					$agentdata[$agent_name]['totvisarejected'] =	$agent_totvisarejected;

					
				} //leads
			}
		}



		$staffs = $this->custom->query("select * from users where u_role=1 ");

		$staff_name = '';
		
		$staffdata = array();
		if($staffs){
			foreach($staffs as $staff){
				$staff_name  = $staff->u_fname.'  '.$staff->u_lname;
				$staff_totapp =0;
				$staff_totpending =0;
				$staff_totcondapproved =0;
				$staff_totapproved =0;
				$staff_totrejected =0;
				$staff_totvisapending =0;
				$staff_totprevisa =0;
				$staff_totdeposit =0;
				$staff_totnopay =0;
				$staff_totvisapproved =0;
				$staff_totvisarejected =0;
				if($leads){
					foreach($leads as $lead){
						
						if($staff->u_id==$lead->l_by){
							$staff_totapp ++;
							if($lead->l_app_status==0){
								$staff_totpending ++;
							}elseif($lead->l_app_status==1){
								$staff_totapproved ++;
								if($lead->l_visa_status==0){
									$staff_totvisapending ++;
								}elseif($lead->l_visa_status==1){
									$staff_totvisapproved ++;
								}else{
									$staff_totvisarejected ++;
								}
							}elseif($lead->l_app_status==2){
								$staff_totrejected ++;
							}else{
								$staff_totcondapproved ++;
							}

							if($lead->l_payment==1){
								$staff_totprevisa++;
							}elseif($lead->l_payment==2){
								$staff_totdeposit++;
							}else{
								$staff_totnopay++;
							}
						}

					}
					$staffdata[$staff_name]['totapp'] =	$staff_totapp;
					$staffdata[$staff_name]['totpending'] =	$staff_totpending;
					$staffdata[$staff_name]['totcondapproved'] =	$staff_totcondapproved;
					$staffdata[$staff_name]['totapproved'] =	$staff_totapproved;
					$staffdata[$staff_name]['totrejected'] =	$staff_totrejected;
					$staffdata[$staff_name]['totvisapending'] =	$staff_totvisapending;
					$staffdata[$staff_name]['totprevisa'] =	$staff_totprevisa;
					$staffdata[$staff_name]['totdeposit'] =	$staff_totdeposit;
					$staffdata[$staff_name]['totnopay'] =	$staff_totnopay;
					$staffdata[$staff_name]['totvisapproved'] =	$staff_totvisapproved;
					$staffdata[$staff_name]['totvisarejected'] =	$staff_totvisarejected;

					
				} //leads
			}
		}
		
		$this->data['staffdata'] =  $staffdata;
		$this->data['agentdata'] =  $agentdata;
		$this->data['userrole'] =  $this->userdet[0]->u_role;
		$this->load->admin_view('dashboard',$this->data);
	}
	
	
	public function users()
	{
		$action = $this->uri->segment(3);
		$id = $this->uri->segment(4);
		$table = "users";

		$this->data['pageinfo'] = array('title'=>'Users','link'=>$this->data['link']);
				
		
		switch ($action) {
			default:
				
				$users = $this->custom->get_where($table,array('u_role!='=>3));
				$this->data['users'] = $users;
				
				$this->load->admin_view('users/index',$this->data);
				break;
			case 'add':
				
				if($this->input->post('savedata')){
					$this->form_validation->set_rules('u_userid', 'User Name', 'required'); 
					$this->form_validation->set_rules('u_fname', 'First Name', 'required'); 
					$this->form_validation->set_rules('u_email', 'Email', 'required'); 
					$this->form_validation->set_rules('u_pass', 'Password', 'required'); 
					$rowData = cleanArray($this->input->post());

					$rowData['u_pass']= $this->input->post('u_pass'); 
					$rowData['created']= date("Y-m-d H:i:s"); 
					$rowData['modified']= date("Y-m-d H:i:s"); 
					$rowData['u_status']= 1; 
					unset($rowData['savedata']);

					if(insertQry('users',$rowData)){
					   redirect('sadmin/users'); 
					}

					foreach($rowData as $ky => $vl){
						$this->data[$ky] = $vl;
					}

				}else{
					getTableInfo($this->dbname,$table);
				}
				
				$this->load->admin_view('users/add',$this->data);
				break;
			case 'edit':

				if($this->input->post('savedata')){
					$this->form_validation->set_rules('u_userid', 'User Name', 'required'); 
					$this->form_validation->set_rules('u_fname', 'First Name', 'required'); 
					$this->form_validation->set_rules('u_email', 'Email', 'required'); 
					$this->form_validation->set_rules('u_pass', 'Password', 'required'); 
					$rowData = cleanArray($this->input->post());

					$rowData['modified']= date("Y-m-d H:i:s"); 
					$rowData['u_status']= 1; 
					unset($rowData['savedata']);

					if(updateQry($table,$rowData,array('u_id'=>$id))){
					   redirect('sadmin/users'); 
					}

					foreach($rowData as $ky => $vl){
						$this->data[$ky] = $vl;
					}

				}else{
					getTableInfo($this->dbname,$table,array('u_id'=>$id));
				}
				
				$this->load->admin_view('users/edit',$this->data);
				break;
			case 'delete':
				
				$id = $this->uri->segment(4);
				$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">Record has been deleted.</div>');
				$this->custom->delete_where($table,array('u_id'=>$id));
				redirect('sadmin/users','refresh'); 
				break;
			
		}

		
		
	}
	
	


	public function leads()
	{
		$action = $this->uri->segment(3);
		$id = $this->uri->segment(4);
		$filter = $this->uri->segment(3);
		$table = "leads";

		$this->data['pageinfo'] = array('title'=>'Application','link'=>$this->data['link']);
		$this->data['statecity'] = $this->custom->get_data('statecity');	
		$this->data['countries'] = $this->custom->get_where('country',array('appliedfor'=>1));	
		
		switch ($action) {
			default:

			$where ='';

				if($filter=="all"){
					$where = '';
				}elseif($filter=="pending"){
					$where = ' and l_app_status=0';
				}elseif($filter=="approved"){
					$where = ' and (l_app_status=1)';
				}elseif($filter=="condapproved"){
					$where = ' and (l_app_status=3)';
				}elseif($filter=="rejected"){
					$where = ' and l_app_status=2';
				}elseif($filter=="visafile"){
					$where = ' and l_app_status=1 and l_visa_status=0';
				}elseif($filter=="visapending"){
					$where = ' and l_app_status=1 and l_visa_status=1';
				}elseif($filter=="visaapproved"){
					$where = ' and l_app_status=1 and l_visa_status=2';
				}elseif($filter=="visarejected"){
					$where = ' and l_app_status=1  and l_visa_status=3';
				}

				if($this->userdet[0]->u_role==3){
					$leads = $this->custom->query("select * from ".$table." where l_id!=0 ".$where);
				}elseif($this->userdet[0]->u_role==1){
					$leads = $this->custom->query("select * from ".$table." where  (l_by='".$this->session->userdata('userId')."' or l_assign='".$this->session->userdata('userId')."') ".$where);
				}elseif($this->userdet[0]->u_role==4){
					$leads = $this->custom->query("select * from ".$table." where  (l_by='".$this->session->userdata('userId')."' or l_assign='".$this->session->userdata('userId')."') ".$where);

					if(!empty($this->userdet[0]->u_assgned_agent)){
                                               
						$pos = strpos($this->userdet[0]->u_assgned_agent, ',');
						
						if ($pos === false) {
							$leads = $this->custom->query("select * from ".$table." where  (l_by='".$this->userdet[0]->u_assgned_agent."') ".$where);
						} else {
							$leads = $this->custom->query("select * from ".$table." where  (l_by in (".$this->userdet[0]->u_assgned_agent.") ) ".$where);
						}
					}


				}else{
					/* $leads = $this->custom->get_where($table,array('l_by'=>$this->session->userdata('userId'))); */
					$leads = $this->custom->query("select * from ".$table." where l_by='".$this->session->userdata('userId')."' ".$where);
				}
				$this->data['leads'] = $leads;
				$this->data['userrole'] =  $this->userdet[0]->u_role;
				
				$this->load->admin_view('leads/index',$this->data);
				break;
			case 'add':
				
				if($this->input->post('savedata')){
					$this->form_validation->set_rules('l_fullname', 'Full Name', 'required'); 
					$this->form_validation->set_rules('l_phone', 'Phone Number', 'required'); 
					/* $this->form_validation->set_rules('l_location', 'Location', 'required');  */
					/* $this->form_validation->set_rules('l_applied_visa', 'Applied For', 'required');  */
					$rowData = cleanArray($this->input->post());


					$lastlead = $this->custom->query("select * from leads order by l_id desc limit 0,1");
					$agentshortname = substr($this->userdet[0]->u_fname,0,3);
					$newfileno = $agentshortname.($lastlead[0]->l_id+1);
					$rowData['l_fileno']= $newfileno; 
					$rowData['created']= date("Y-m-d H:i:s"); 
					$rowData['l_by']= $this->session->userdata('userId'); 
					$rowData['modified']= date("Y-m-d H:i:s"); 
					unset($rowData['savedata']);

					if(insertQry('leads',$rowData)){
						$id = $this->db->insert_id();
						
						/* l_photo */
						if(!empty($_FILES["l_photo"]['name'])){

							$upload_param['filename'] = 'l_photo';
							$upload_param['path'] = 'leads';
							$upload_param['types'] = 'gif|jpg|jpeg|png|doc|docx|pdf';
							$upload_param['size'] = '1024';
							$upload_param['table'] = "leads";
							$upload_param['field'] = 'l_photo';
							$upload_param['pkfield'] = 'l_id';
							$upload_param['pkval'] = $id;
							
							$filestaus = fileupload($upload_param);
							if($filestaus['error']==1){
								$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">File format not supported.</div>');
							}else{
								$this->session->set_flashdata('error_msg', '<div class="alert alert-success">File has been uploaded.</div>');
							}
						}
						/* upload10 */
						if(!empty($_FILES["upload10"]['name'])){

							$upload_param['filename'] = 'upload10';
							$upload_param['path'] = 'leads';
							$upload_param['types'] = 'gif|jpg|jpeg|png|doc|docx|pdf';
							$upload_param['size'] = '1024';
							$upload_param['table'] = "leads";
							$upload_param['field'] = 'upload10';
							$upload_param['pkfield'] = 'l_id';
							$upload_param['pkval'] = $id;
							
							$filestaus = fileupload($upload_param);
							if($filestaus['error']==1){
								$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">File format not supported.</div>');
							}else{
								$this->session->set_flashdata('error_msg', '<div class="alert alert-success">File has been uploaded.</div>');
							}
						}
						/* upload12 */
						if(!empty($_FILES["upload12"]['name'])){

							$upload_param['filename'] = 'upload12';
							$upload_param['path'] = 'leads';
							$upload_param['types'] = 'gif|jpg|jpeg|png|doc|docx|pdf';
							$upload_param['size'] = '1024';
							$upload_param['table'] = "leads";
							$upload_param['field'] = 'upload12';
							$upload_param['pkfield'] = 'l_id';
							$upload_param['pkval'] = $id;
							
							$filestaus = fileupload($upload_param);
							if($filestaus['error']==1){
								$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">File format not supported.</div>');
							}else{
								$this->session->set_flashdata('error_msg', '<div class="alert alert-success">File has been uploaded.</div>');
							}
						}
						/* uploaddiploma */
						if(!empty($_FILES["uploaddiploma"]['name'])){

							$upload_param['filename'] = 'uploaddiploma';
							$upload_param['path'] = 'leads';
							$upload_param['types'] = 'gif|jpg|jpeg|png|doc|docx|pdf';
							$upload_param['size'] = '1024';
							$upload_param['table'] = "leads";
							$upload_param['field'] = 'uploaddiploma';
							$upload_param['pkfield'] = 'l_id';
							$upload_param['pkval'] = $id;
							
							$filestaus = fileupload($upload_param);
							if($filestaus['error']==1){
								$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">File format not supported.</div>');
							}else{
								$this->session->set_flashdata('error_msg', '<div class="alert alert-success">File has been uploaded.</div>');
							}
						}
						/* uploadgrad */
						if(!empty($_FILES["uploadgrad"]['name'])){

							$upload_param['filename'] = 'uploadgrad';
							$upload_param['path'] = 'leads';
							$upload_param['types'] = 'gif|jpg|jpeg|png|doc|docx|pdf';
							$upload_param['size'] = '1024';
							$upload_param['table'] = "leads";
							$upload_param['field'] = 'uploadgrad';
							$upload_param['pkfield'] = 'l_id';
							$upload_param['pkval'] = $id;
							
							$filestaus = fileupload($upload_param);
							if($filestaus['error']==1){
								$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">File format not supported.</div>');
							}else{
								$this->session->set_flashdata('error_msg', '<div class="alert alert-success">File has been uploaded.</div>');
							}
						}
						/* uploadpg */
						if(!empty($_FILES["uploadpg"]['name'])){

							$upload_param['filename'] = 'uploadpg';
							$upload_param['path'] = 'leads';
							$upload_param['types'] = 'gif|jpg|jpeg|png|doc|docx|pdf';
							$upload_param['size'] = '1024';
							$upload_param['table'] = "leads";
							$upload_param['field'] = 'uploadpg';
							$upload_param['pkfield'] = 'l_id';
							$upload_param['pkval'] = $id;
							
							$filestaus = fileupload($upload_param);
							if($filestaus['error']==1){
								$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">File format not supported.</div>');
							}else{
								$this->session->set_flashdata('error_msg', '<div class="alert alert-success">File has been uploaded.</div>');
							}
						}
						/* misc */
						if(!empty($_FILES["misc"]['name'])){

							/* upload multiple */
							if(!empty($_FILES['misc']['name'])){
							$countfiles = count($_FILES['misc']['name']);
					  
								for($i=0;$i<$countfiles;$i++){
							
									if(!empty($_FILES['misc']['name'][$i])){
		
										// Define new $_FILES array - $_FILES['file']
										$_FILES['file']['name'] = $_FILES['misc']['name'][$i];
										$_FILES['file']['type'] = $_FILES['misc']['type'][$i];
										$_FILES['file']['tmp_name'] = $_FILES['misc']['tmp_name'][$i];
										$_FILES['file']['error'] = $_FILES['misc']['error'][$i];
										$_FILES['file']['size'] = $_FILES['misc']['size'][$i];
								
										// Set preference
										$config['upload_path'] = './uploads/documents/'; 
										$config['allowed_types'] = 'gif|jpg|jpeg|png|pdf|doc|docx|bmp';
										$config['max_size'] = '50000'; // max_size in kb
										$config['file_name'] = time() . '_' . $_FILES['misc']['name'][$i];
								
										//Load upload library
										$this->load->library('upload',$config); 
										$arr = array('msg' => 'something went wrong', 'success' => false);
										// File upload
										if($this->upload->do_upload('file')){
										
											$data = $this->upload->data(); 
											$insert['r_id'] = 0;
											$insert['l_id'] = $id;
											$insert['sop'] = 1;
											$insert['education'] = 0;
											$insert['d_file'] = $data['file_name'];
											$this->db->insert('documents',$insert);
											$get = $this->db->insert_id();
											$arr = array('msg' => 'Image has been uploaded successfully', 'success' => true);
								
										}
									}
							
								}
							}
						}

					   redirect('sadmin/leads','refersh'); 
					}

					foreach($rowData as $ky => $vl){
						$this->data[$ky] = $vl;
					}

				}else{
					getTableInfo($this->dbname,$table);
				}
				
				$this->load->admin_view('leads/add',$this->data);
				break;
			case 'edit':
				if($this->userdet[0]->u_role==3){
					$this->custom->updateData("leads",array('l_admin_status'=>1),array('l_id'=>$id));
				}
				if($this->userdet[0]->u_role==1){
					$this->custom->updateData("leads",array('l_staff_status'=>1),array('l_id'=>$id));
				}
				if($this->input->post('savedata')){
					$this->form_validation->set_rules('l_fullname', 'Full Name', 'required'); 
					$this->form_validation->set_rules('l_phone', 'Phone Number', 'required'); 
					$rowData = cleanArray($this->input->post());

					$rowData['modified']= date("Y-m-d H:i:s"); 
					unset($rowData['savedata']);

					if(updateQry($table,$rowData,array('l_id'=>$id))){

						/* upload10 */
						if(!empty($_FILES["upload10"]['name'])){

							$upload_param['filename'] = 'upload10';
							$upload_param['path'] = 'leads';
							$upload_param['types'] = 'gif|jpg|jpeg|png|doc|docx|pdf';
							$upload_param['size'] = '1024';
							$upload_param['table'] = "leads";
							$upload_param['field'] = 'upload10';
							$upload_param['pkfield'] = 'l_id';
							$upload_param['pkval'] = $id;
							
							$filestaus = fileupload($upload_param);
							if($filestaus['error']==1){
								$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">File format not supported.</div>');
							}else{
								$this->session->set_flashdata('error_msg', '<div class="alert alert-success">File has been uploaded.</div>');
							}
						}
						/* upload12 */
						if(!empty($_FILES["upload12"]['name'])){

							$upload_param['filename'] = 'upload12';
							$upload_param['path'] = 'leads';
							$upload_param['types'] = 'gif|jpg|jpeg|png|doc|docx|pdf';
							$upload_param['size'] = '1024';
							$upload_param['table'] = "leads";
							$upload_param['field'] = 'upload12';
							$upload_param['pkfield'] = 'l_id';
							$upload_param['pkval'] = $id;
							
							$filestaus = fileupload($upload_param);
							if($filestaus['error']==1){
								$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">File format not supported.</div>');
							}else{
								$this->session->set_flashdata('error_msg', '<div class="alert alert-success">File has been uploaded.</div>');
							}
						}
						/* uploaddiploma */
						if(!empty($_FILES["uploaddiploma"]['name'])){

							$upload_param['filename'] = 'uploaddiploma';
							$upload_param['path'] = 'leads';
							$upload_param['types'] = 'gif|jpg|jpeg|png|doc|docx|pdf';
							$upload_param['size'] = '1024';
							$upload_param['table'] = "leads";
							$upload_param['field'] = 'uploaddiploma';
							$upload_param['pkfield'] = 'l_id';
							$upload_param['pkval'] = $id;
							
							$filestaus = fileupload($upload_param);
							if($filestaus['error']==1){
								$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">File format not supported.</div>');
							}else{
								$this->session->set_flashdata('error_msg', '<div class="alert alert-success">File has been uploaded.</div>');
							}
						}
						/* uploadgrad */
						if(!empty($_FILES["uploadgrad"]['name'])){

							$upload_param['filename'] = 'uploadgrad';
							$upload_param['path'] = 'leads';
							$upload_param['types'] = 'gif|jpg|jpeg|png|doc|docx|pdf';
							$upload_param['size'] = '1024';
							$upload_param['table'] = "leads";
							$upload_param['field'] = 'uploadgrad';
							$upload_param['pkfield'] = 'l_id';
							$upload_param['pkval'] = $id;
							
							$filestaus = fileupload($upload_param);
							if($filestaus['error']==1){
								$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">File format not supported.</div>');
							}else{
								$this->session->set_flashdata('error_msg', '<div class="alert alert-success">File has been uploaded.</div>');
							}
						}
						/* uploadpg */
						if(!empty($_FILES["uploadpg"]['name'])){

							$upload_param['filename'] = 'uploadpg';
							$upload_param['path'] = 'leads';
							$upload_param['types'] = 'gif|jpg|jpeg|png|doc|docx|pdf';
							$upload_param['size'] = '1024';
							$upload_param['table'] = "leads";
							$upload_param['field'] = 'uploadpg';
							$upload_param['pkfield'] = 'l_id';
							$upload_param['pkval'] = $id;
							
							$filestaus = fileupload($upload_param);
							if($filestaus['error']==1){
								$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">File format not supported.</div>');
							}else{
								$this->session->set_flashdata('error_msg', '<div class="alert alert-success">File has been uploaded.</div>');
							}
						}
						
						/* sop */
						if(!empty($_FILES["misc"]['name'])){

							/* upload multiple */
							if(!empty($_FILES['misc']['name'])){
							$countfiles = count($_FILES['misc']['name']);
					  
								for($i=0;$i<$countfiles;$i++){
							
									if(!empty($_FILES['misc']['name'][$i])){
		
										// Define new $_FILES array - $_FILES['file']
										$_FILES['file']['name'] = $_FILES['misc']['name'][$i];
										$_FILES['file']['type'] = $_FILES['misc']['type'][$i];
										$_FILES['file']['tmp_name'] = $_FILES['misc']['tmp_name'][$i];
										$_FILES['file']['error'] = $_FILES['misc']['error'][$i];
										$_FILES['file']['size'] = $_FILES['misc']['size'][$i];
								
										// Set preference
										$config['upload_path'] = './uploads/documents/'; 
										$config['allowed_types'] = 'gif|jpg|jpeg|png|pdf|doc|docx|bmp';
										$config['max_size'] = '50000'; // max_size in kb
										$config['file_name'] = time() . '_' . $_FILES['misc']['name'][$i];
								
										//Load upload library
										$this->load->library('upload',$config); 
										$arr = array('msg' => 'something went wrong', 'success' => false);
										// File upload
										if($this->upload->do_upload('file')){
										
											$data = $this->upload->data(); 
											$insert['r_id'] = 0;
											$insert['l_id'] = $id;
											$insert['sop'] = 1;
											$insert['education'] = 0;
											$insert['d_file'] = $data['file_name'];
											$this->db->insert('documents',$insert);
											$get = $this->db->insert_id();
											$arr = array('msg' => 'Image has been uploaded successfully', 'success' => true);
								
										}
									}
							
								}
							}
						}

					    redirect('sadmin/leads','refersh');  
					}

					foreach($rowData as $ky => $vl){
						$this->data[$ky] = $vl;
					}

				}else{
					getTableInfo($this->dbname,$table,array('l_id'=>$id));
				}
				
				$docs = $this->custom->get_where("documents",array('l_id'=>$id));
				if($docs){
					$sopimg = array();
					$eduimg = array();
					foreach($docs as $doc){
						
						if($doc->sop==1){
							$sopimg[$doc->d_id]=$doc->d_file;
						}
						
						
						
						if($doc->education==1){
							$eduimg[$doc->d_id]=$doc->d_file;
						}
						
					}
					$this->data['sopimg'] = $sopimg;
					$this->data['eduimg'] = $eduimg;
				}
				
				$this->load->admin_view('leads/edit',$this->data);
				break;
			case 'delete':
				
				$id = $this->uri->segment(4);
				$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">Record has been deleted.</div>');
				$this->custom->delete_where($table,array('l_id'=>$id));
				redirect('sadmin/leads','refresh'); 
				break;
			
			case 'approve':
				
					$lid = $this->uri->segment(4);
					$this->session->set_flashdata('error_msg', '<div class="alert alert-success">Application has been Approved.</div>');
					$this->custom->updateData("leads",array('l_app_status'=>1),array('l_id'=>$lid));
					redirect('sadmin/leads','refresh'); 
					break;
					case 'filevisa':
				
						$lid = $this->uri->segment(4);
						$this->session->set_flashdata('error_msg', '<div class="alert alert-success">Visa has been Filed.</div>');
						$this->custom->updateData("leads",array('l_visa_status'=>1),array('l_id'=>$lid));
						redirect('sadmin/leads','refresh'); 
						break;
					case 'approvevisa':
				
						$lid = $this->uri->segment(4);
						$this->session->set_flashdata('error_msg', '<div class="alert alert-success">Visa has been Approved.</div>');
						$this->custom->updateData("leads",array('l_visa_status'=>2),array('l_id'=>$lid));
						redirect('sadmin/leads','refresh'); 
						break;
				
		}

		
		
	}

	public function countries()
	{
		$action = $this->uri->segment(3);
		$id = $this->uri->segment(4);
		$filter = $this->uri->segment(3);
		$table = "country";

		$this->data['pageinfo'] = array('title'=>'Countires','link'=>$this->data['link']);
		
		switch ($action) {
			default:

			$where ='';

				

				$countries = $this->custom->get_data($table);
				
				$this->data['countries'] = $countries;
				
				$this->load->admin_view('countries/index',$this->data);
				break;
			case 'add':
				
				if($this->input->post('savedata')){
					$this->form_validation->set_rules('cname', 'Title', 'required'); 
					$this->form_validation->set_rules('code', 'Code', 'required'); 
					$rowData = cleanArray($this->input->post());


					/* $rowData['created']= date("Y-m-d H:i:s"); 
					$rowData['modified']= date("Y-m-d H:i:s");  */
					unset($rowData['savedata']);

					if(insertQry($table,$rowData)){
						$id = $this->db->insert_id();
						
						

					   redirect('sadmin/countries','refersh'); 
					}

					foreach($rowData as $ky => $vl){
						$this->data[$ky] = $vl;
					}

				}else{
					getTableInfo($this->dbname,$table);
				}
				
				$this->load->admin_view('countries/add',$this->data);
				break;
			case 'edit':

				if($this->input->post('savedata')){
					$this->form_validation->set_rules('cname', 'Title', 'required'); 
					$this->form_validation->set_rules('code', 'Code', 'required'); 
					$rowData = cleanArray($this->input->post());

					/* $rowData['modified']= date("Y-m-d H:i:s");  */
					unset($rowData['savedata']);

					if(updateQry($table,$rowData,array('id'=>$id))){

					
					    redirect('sadmin/countries','refersh');  
					}

					foreach($rowData as $ky => $vl){
						$this->data[$ky] = $vl;
					}

				}else{
					getTableInfo($this->dbname,$table,array('id'=>$id));
				}
				
				$this->load->admin_view('countries/edit',$this->data);
				break;
			case 'delete':
				
				$id = $this->uri->segment(4);
				$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">Record has been deleted.</div>');
				$this->custom->delete_where($table,array('id'=>$id));
				redirect('sadmin/countries','refresh'); 
				break;
			
			case 'approve':
				
					$lid = $this->uri->segment(4);
					$this->session->set_flashdata('error_msg', '<div class="alert alert-success">Application has been Approved.</div>');
					$this->custom->updateData("countries",array('l_app_status'=>1),array('l_id'=>$lid));
					redirect('sadmin/countries','refresh'); 
					break;
			case 'approvevisa':
				
						$lid = $this->uri->segment(4);
						$this->session->set_flashdata('error_msg', '<div class="alert alert-success">Visa has been Approved.</div>');
						$this->custom->updateData("countries",array('l_visa_status'=>1),array('l_id'=>$lid));
						redirect('sadmin/countries','refresh'); 
						break;
				
		}

		
		
	}


	
	public function universities()
	{
		$action = $this->uri->segment(3);
		$id = $this->uri->segment(4);
		$filter = $this->uri->segment(3);
		$table = "universities";

		$this->data['pageinfo'] = array('title'=>'Universities','link'=>$this->data['link']);
		$this->data['countries'] = $this->custom->get_where("country",array('appliedfor'=>1));
		switch ($action) {
			default:

			$where ='';

				

				$universities = $this->custom->get_data($table);
				
				
				$this->data['universities'] = $universities;
				
				$this->load->admin_view('universities/index',$this->data);
				break;
			case 'add':
				
				if($this->input->post('savedata')){
					$this->form_validation->set_rules('ui_name', 'Name', 'required'); 
					$rowData = cleanArray($this->input->post());


					/* $rowData['created']= date("Y-m-d H:i:s"); 
					$rowData['modified']= date("Y-m-d H:i:s");  */
					unset($rowData['savedata']);

					if(insertQry($table,$rowData)){
						$id = $this->db->insert_id();
						
						

					   redirect('sadmin/universities','refersh'); 
					}

					foreach($rowData as $ky => $vl){
						$this->data[$ky] = $vl;
					}

				}else{
					getTableInfo($this->dbname,$table);
				}
				
				$this->load->admin_view('universities/add',$this->data);
				break;
			case 'edit':

				if($this->input->post('savedata')){
					$this->form_validation->set_rules('ui_name', 'Name', 'required'); 
					$rowData = cleanArray($this->input->post());

					/* $rowData['modified']= date("Y-m-d H:i:s");  */
					unset($rowData['savedata']);

					if(updateQry($table,$rowData,array('ui_id'=>$id))){

					
					    redirect('sadmin/universities','refersh');  
					}

					foreach($rowData as $ky => $vl){
						$this->data[$ky] = $vl;
					}

				}else{
					getTableInfo($this->dbname,$table,array('ui_id'=>$id));
				}
				
				$this->load->admin_view('universities/edit',$this->data);
				break;
			case 'delete':
				
				$id = $this->uri->segment(4);
				$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">Record has been deleted.</div>');
				$this->custom->delete_where($table,array('ui_id'=>$id));
				redirect('sadmin/universities','refresh'); 
				break;
			
			case 'approve':
				
					$lid = $this->uri->segment(4);
					$this->session->set_flashdata('error_msg', '<div class="alert alert-success">Application has been Approved.</div>');
					$this->custom->updateData("universities",array('l_app_status'=>1),array('l_id'=>$lid));
					redirect('sadmin/universities','refresh'); 
					break;
			case 'approvevisa':
				
						$lid = $this->uri->segment(4);
						$this->session->set_flashdata('error_msg', '<div class="alert alert-success">Visa has been Approved.</div>');
						$this->custom->updateData("universities",array('l_visa_status'=>1),array('l_id'=>$lid));
						redirect('sadmin/universities','refresh'); 
						break;
				
		}

		
		
	}
	

	public function documents()
	{
		$action = $this->uri->segment(3);
		$id = $this->uri->segment(4);
		$filter = $this->uri->segment(3);
		$table = "univ_docs";
		$field_id = "u_id";

		$this->data['pageinfo'] = array('title'=>'Documents','link'=>$this->data['link']);
		
		switch ($action) {
			default:

			$where ='';

			$where = '';
			if(!empty($this->input->post('fltuniv'))){
				$where .=" and u_name like '%".$this->input->post('fltuniv')."%'";
			}
			if(!empty($this->input->post('fltcountry'))){
				$where .=" and u_country like '%".$this->input->post('fltcountry')."%'";
			}
			if(!empty($this->input->post('fltcourses'))){
				$where .=" and u_courses like '%".$this->input->post('fltcourses')."%'";
			}
			if(!empty($this->input->post('fltlocation'))){
				$where .=" and u_location like '%".$this->input->post('fltlocation')."%'";
			}
			if(!empty($this->input->post('fltacademics'))){
				$where .=" and u_academic like '%".$this->input->post('fltacademics')."%'";
			}
			if(!empty($this->input->post('fltenglish'))){
				$where .=" and u_english like '%".$this->input->post('fltenglish')."%'";
			}
			if(!empty($this->input->post('fltintake'))){
				$where .=" and u_intake like '%".$this->input->post('fltintake')."%'";
			}
			if(!empty($this->input->post('fltregion'))){
				$where .=" and u_region like '%".$this->input->post('fltregion')."%'";
			}

				$documents = $this->custom->query("Select * from ".$table." where u_id!=0 ".$where);
				
				$this->data['documents'] = $documents;
				
				$this->load->admin_view('documents/index',$this->data);
				break;
			case 'add':
				
				if($this->input->post('savedata')){
					$this->form_validation->set_rules('u_name', 'University Name', 'required'); 
					$this->form_validation->set_rules('u_country', 'Country', 'required'); 
					$rowData = cleanArray($this->input->post());


					/* $rowData['created']= date("Y-m-d H:i:s"); 
					$rowData['modified']= date("Y-m-d H:i:s");  */
					unset($rowData['savedata']);

					if(insertQry($table,$rowData)){
						$id = $this->db->insert_id();
						
						

					   redirect('sadmin/documents','refersh'); 
					}

					foreach($rowData as $ky => $vl){
						$this->data[$ky] = $vl;
					}

				}else{
					getTableInfo($this->dbname,$table);
				}
				
				$this->load->admin_view('documents/add',$this->data);
				break;
			case 'edit':

				if($this->input->post('savedata')){
					$this->form_validation->set_rules('u_name', 'University Name', 'required'); 
					$this->form_validation->set_rules('u_country', 'Country', 'required'); 
					$rowData = cleanArray($this->input->post());

					/* $rowData['modified']= date("Y-m-d H:i:s");  */
					unset($rowData['savedata']);

					if(updateQry($table,$rowData,array($field_id=>$id))){

					
					    redirect('sadmin/documents','refersh');  
					}

					foreach($rowData as $ky => $vl){
						$this->data[$ky] = $vl;
					}

				}else{
					getTableInfo($this->dbname,$table,array($field_id=>$id));
				}
				
				$this->load->admin_view('documents/edit',$this->data);
				break;
			case 'delete':
				
				$id = $this->uri->segment(4);
				$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">Record has been deleted.</div>');
				$this->custom->delete_where($table,array($field_id=>$id));
				redirect('sadmin/documents','refresh'); 
				break;
			
			
				
		}

		
		
	}
	
	


	public function changepassword() {
		// $this->data = array();
		 $action = $this->uri->segment(3);

		 $table = "users";

		$this->data['pageinfo'] = array('title'=>'Change Password','link'=>$this->data['link']);

		 switch ($action) :
 
			 default:
				 // Prepare error code
				 $error_code = $this->uri->segment(4);
				 $error_msg = "";
				 // Prepare error message
					 $id = $this->session->userId;
				  
 
				 if (isset($_POST) && !empty($_POST)) {
					 $old_pass = $_POST['old_pass'];
					 $new_pass = $_POST['new_pass'];
					 $confirm_pass = $_POST['confirm_pass'];
					 
					 $usr_det = $this->custom->get_where('users',array('u_id'=>$id,'u_pass'=>$old_pass));
					
					 if($usr_det){
							 if($new_pass==$confirm_pass){
								 $uparr = array(
									 'u_pass'=>$new_pass,
								 );
								
								 /* if(updateQry('users', $uparr, array('u_id'=>$id))){ */
								if($this->custom->updateData("users",$uparr,array('u_id'=>$id))){
									$this->session->set_flashdata('error_msg', '<div class="alert alert-success">Password has been changes successfully</div>');
								
									redirect('sadmin/changepassword', 'refresh');
								 }else{
									$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">Something went wrong, please try again.</div>');
									qry();
									redirect('sadmin/changepassword', 'refresh');
								 }
							 }else{
								$this->session->set_flashdata('error_msg', '<div class="alert alert-warning">Conform Password Does not Match.</div>');
								redirect('sadmin/changepassword', 'refresh');
							 }
						 
					 }else{
						$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">Old Password Does not match.</div>');
						redirect('sadmin/changepassword', 'refresh');
					 }
					 
				 }
				 $this->data['error_msg'] = $error_msg;
				 $this->load->admin_view('changepassword/add', $this->data);
				 break;
 
		 endswitch;
	 }



	public function settings()
	{
		$action = $this->uri->segment(3);
		$id = $this->uri->segment(4);
		$table = "settings";
		
		$this->data['pageinfo'] = array('title'=>'Settings','link'=>$this->data['link']);
		$this->data['settings'] = $this->custom->get_data($table);
		
		
			
				$id = $this->uri->segment('4');
				if($this->input->post('updatedata')){
					$this->form_validation->set_rules('s_sitename', 'Website Name', 'required'); 
					$this->form_validation->set_rules('s_resume_access', 'Resume Access', 'required');  
					
					$rowData = cleanArray($this->input->post());
					
					$rowData['s_disclaimer']= $this->input->post('s_disclaimer');
					$rowData['s_terms_conditions']= $this->input->post('s_terms_conditions');
					$rowData['s_privacy_policy']= $this->input->post('s_privacy_policy');
					/* $rowData['created']= date("Y-m-d H:i:s"); 
					$rowData['modified']= date("Y-m-d H:i:s");  */
					unset($rowData['updatedata']);

					if(updateQry($table,$rowData,array('s_id'=>1))){
					   redirect('sadmin/settings'); 
					}

					foreach($rowData as $ky => $vl){
						$this->data[$ky] = $vl;
					}

				}else{
					getTableInfo($this->dbname,$table,array('s_id'=>1));
				}
				
				$this->load->admin_view('settings/edit',$this->data);
			
			
			
		

		
		
	}
	

	
	public function ajax_reject_app()
	{
		$lid = $this->input->post('lid');
		$reject_comment = $this->input->post('reject_comment');
		
		$up_data = array(
			'l_remarks' => $reject_comment,
			'l_app_status' => 2,
		);
		
		
		/* $upqry = updateQry("leads",$up_data,array('l_id'=>$lid)); */
		$upqry = $this->custom->updateData("leads",$up_data,array('l_id'=>$lid));
		
		if($upqry){
			echo '<div class="alert alert-success">Application has been rejected.</div>';
		}else{
			echo '<div class="alert alert-danger">Something went wrong. Please try again.</div>';
		}
	
			
		
	}
	
	public function ajax_delete_img()
	{
		$table = 'documents';
		$path = './uploads/documents/';

		$id = $this->input->post('id');
		$getdata = $this->custom->get_where($table,array('d_id'=>$id));
		if($getdata){
			$file = $getdata[0]->d_file;
			
			if(unlink($path.$file)){
				$this->custom->delete_where($table,array('d_id'=>$id));
				echo $id;
			}else{
				echo 0;
			}
			
		}else{
				echo 0;
		}
		
		
	}


	public function ajax_approve_app()
	{
		$lid = $this->input->post('lid');
		$approve_comment = $this->input->post('approve_comment');
		$approve_status = $this->input->post('approve_status');
		
		$up_data = array(
			'l_app_status' => $approve_status,
		);
		
		
		/* $upqry = updateQry("leads",$up_data,array('l_id'=>$lid)); */
		$upqry = $this->custom->updateData("leads",$up_data,array('l_id'=>$lid));

		$date_remark = date('Y-m-d');
		$today = date("Y-m-d H:i:s");
		
		$ins_data = array(
			'l_id' => $lid,
			'r_by' => $this->session->userdata('userId'),
			'r_remark' => $approve_comment,
			'r_date' => $date_remark,
			
			'created' => $today,
			'modified' => $today,
		);
		
		
		/* $upqry = updateQry("leads",$up_data,array('l_id'=>$lid)); */
		$inqry = $this->custom->insert("remarks",$ins_data);
		
		if($upqry){
			echo '<div class="alert alert-success">Application has been approved.</div>';
		}else{
			echo '<div class="alert alert-danger">Something went wrong. Please try again.</div>';
		}
	
			
		
	}
	
	
	public function ajax_universitylist()
	{
		$cid = $this->input->post('cid');
		
		$getlist='';
		if(!empty($cid)){
			$getlist = $this->custom->get_where("universities",array('c_id'=>$cid,'ui_status'=>1));
		}
		
		$option ='<option value=""> Choose University </option>';
		if($getlist){
			foreach($getlist as $university){
				$option .='<option value="'.$university->ui_id.'">'.$university->ui_name.'</option>';
			}
		}
		echo $option;
		
	
			
		
	}

	public function ajax_export_csv()
	{
		$lid = $this->input->post('lid');
		
		
		
		/* $upqry = updateQry("leads",$up_data,array('l_id'=>$lid)); */
		$getleads = $this->custom->get_where("remarks",array('l_id'=>$lid));

		$csvarr = array ();

		if($getleads){
			foreach($getleads as $ldata){
				$usrdet = $this->custom->get_where("users",array('u_id'=>$ldata->r_by));
				$uname ='';
				if($usrdet){
					$uname = $usrdet[0]->u_fname.'  '.$usrdet[0]->u_lname;
				}
				$getdocs = $this->custom->get_where("documents",array('r_id'=>$ldata->r_id));
				$files ='';
				if($getdocs){
					$i=1;
					foreach($getdocs as $getdoc){
						$files .='File '.$i.' ';
						$i++;
					}
				}

				$dt = date('d/m/Y H:i',strtotime($ldata->created));
				$remark = $ldata->r_remark;
				$files = $files;
				$addby = $uname;
				$csvarr[] = [$dt,$remark,$files,$addby];
			}
		}
		
		// file name 
		$filename = 'remarks_'.date('Ymd_Hi').'.csv'; 
		header('Content-Type: text/csv; charset=utf-8');
		/* header("Content-Description: File Transfer");  */
		header("Content-Disposition: attachment; filename=$filename"); 
		/* header("Content-Type: application/csv; "); */
		
		// get data 
		$usersData = $csvarr;
	 
		// file creation 
		$file = fopen('php://output', 'w');
	  
		$header = array("Dated","Reamrks","Documents","Add by"); 
		fputcsv($file, $header);
		foreach ($usersData as $key=>$line){ 
		  fputcsv($file,$line); 
		}
		fclose($file); 
		exit; 
	
			
		
	}

	public function ajax_assign_app()
	{
		$lid = $this->input->post('lid');
		$staff_id = $this->input->post('staff_id');
		$today = date("Y-m-d H:i:s");
		$up_data = array(
			'l_assign' => $staff_id,
			'l_datetime' => $today,
			'l_admin_status' => 0,
			'l_staff_status' => 0,
		);
		
			
		/* $upqry = updateQry("leads",$up_data,array('l_id'=>$lid)); */
		$upqry = $this->custom->updateData("leads",$up_data,array('l_id'=>$lid));

		
	
		
		if($upqry){
			echo '<div class="alert alert-success">Application has been approved.</div>';
		}else{
			echo '<div class="alert alert-danger">Something went wrong. Please try again.</div>';
		}
	
			
		
	}


	public function ajax_assignagent_app()
	{
		$uid = $this->input->post('uid');
		$agent_id = implode(',',$this->input->post('agent_id'));
		$today = date("Y-m-d H:i:s");
		$up_data = array(
			'u_assgned_agent' => $agent_id,
			
		);
		
			
		/* $upqry = updateQry("leads",$up_data,array('l_id'=>$lid)); */
		$upqry = $this->custom->updateData("users",$up_data,array('u_id'=>$uid));

		
	
		
		if($upqry){
			echo '<div class="alert alert-success">Application has been approved.</div>';
		}else{
			echo '<div class="alert alert-danger">Something went wrong. Please try again.</div>';
		}
	
			
		
	}


	public function ajax_payment_add()
	{
		$lid = $this->input->post('lid');
		$pay = $this->input->post('pay');
		$today = date("Y-m-d H:i:s");
		$up_data = array(
			'l_payment' => $pay,
			
		);
		
			
		/* $upqry = updateQry("leads",$up_data,array('l_id'=>$lid)); */
		$upqry = $this->custom->updateData("leads",$up_data,array('l_id'=>$lid));

		
	
		
		if($upqry){
			echo '<div class="alert alert-success">Payment status has been Updated.</div>';
		}else{
			echo '<div class="alert alert-danger">Something went wrong. Please try again.</div>';
		}
	
			
		
	}
	

	public function ajax_add_remark()
	{
		$lid = $this->input->post('lid');
		$remark = $this->input->post('remark');
		/* $date_remark = $this->input->post('date_remark'); */
		$date_remark = date('Y-m-d');
		$today = date("Y-m-d H:i:s");
		
		$ins_data = array(
			'l_id' => $lid,
			'r_by' => $this->session->userdata('userId'),
			'r_remark' => $remark,
			'r_date' => $date_remark,
			
			'created' => $today,
			'modified' => $today,
		);
		
		
		/* $upqry = updateQry("leads",$up_data,array('l_id'=>$lid)); */
		$inqry = $this->custom->insert("remarks",$ins_data); 
		$insid = $this->db->insert_id();

		/* upload multiple */
		if(!empty($_FILES['files']['name'])){
		$countfiles = count($_FILES['files']['name']);
  
			for($i=0;$i<$countfiles;$i++){
		
				if(!empty($_FILES['files']['name'][$i])){
		
					// Define new $_FILES array - $_FILES['file']
					$_FILES['file']['name'] = $_FILES['files']['name'][$i];
					$_FILES['file']['type'] = $_FILES['files']['type'][$i];
					$_FILES['file']['tmp_name'] = $_FILES['files']['tmp_name'][$i];
					$_FILES['file']['error'] = $_FILES['files']['error'][$i];
					$_FILES['file']['size'] = $_FILES['files']['size'][$i];
			
					// Set preference
					$config['upload_path'] = './uploads/documents/'; 
					$config['allowed_types'] = 'gif|jpg|jpeg|png|pdf|doc|docx';
					$config['max_size'] = '5000'; // max_size in kb
					$config['file_name'] = time() . '_' . $_FILES['files']['name'][$i];
			
					//Load upload library
					$this->load->library('upload',$config); 
					$arr = array('msg' => 'something went wrong', 'success' => false);
					// File upload
					if($this->upload->do_upload('file')){
					
						$data = $this->upload->data(); 
						$insert['r_id'] = $insid;
						$insert['d_file'] = $data['file_name'];
						$this->db->insert('documents',$insert);
						$get = $this->db->insert_id();
						$arr = array('msg' => 'Image has been uploaded successfully', 'success' => true);
			
					}
				}
		
			}
		}
		/* echo json_encode($arr); */
		
		if($inqry){
			echo '<div class="alert alert-success">Remarks added Successfully.</div>';
		}else{
			echo '<div class="alert alert-danger">Something went wrong. Please try again.</div>';
		}
	
			
		
	}

	public function ajax_view_remarks()
	{
		$lid = $this->input->post('lid');
		
		
		$upqry = $this->custom->query("select * from remarks where l_id = '".$lid."' order by r_id desc");
		
		if($upqry){
			echo '<input type="button" class="btn btn-info exportcsv" value="Download CSV File"/>';
			echo '<table class="table myTable">'; 
			echo '<tr><th>Dated</th><th>Remarks</th><th>Documents</th><th>Add by</th></tr>';
			foreach($upqry as $upqry){
				$rem_doc = $this->custom->get_where("documents",array('r_id'=>$upqry->r_id));
				$users = $this->custom->get_where("users",array('u_id'=>$upqry->r_by));
				$downfile ='';
				$i=1;
				if($rem_doc){
					foreach($rem_doc as $remdoc){
						$downfile .= '<a href="'.base_url('uploads/documents/'.$remdoc->d_file).'" target="_blank">File'.$i.'</a> ';
						$i++;
					}
				}
					if($upqry->r_read==0){
						echo '<tr><td width="20%"><b>'.dateFormat('d/m/Y H:i',$upqry->created).'</b></td><td><b>'.$upqry->r_remark.'</b></td><td><b>'.$downfile.'</b></td><td><b>'.$users[0]->u_fname.' '.$users[0]->u_lname.'</b></td></tr>';
					}else{
					echo '<tr><td width="20%">'.dateFormat('d/m/Y H:i',$upqry->created).'</td><td>'.$upqry->r_remark.'</td><td>'.$downfile.'</td><td>'.$users[0]->u_fname.' '.$users[0]->u_lname.'</td></tr>';
					}
				}
			echo '</table>';
		}else{
			echo '<div class="alert alert-info">There are no remarks.</div>';
		}
		$this->custom->updateData("remarks",array('r_read'=>1),array('l_id'=>$lid,'r_by!='=>$this->session->userData('userId')));
		
			
		
	}

	public function ajax_view_app()
	{
		$lid = $this->input->post('lid');
		
		if($this->userdet[0]->u_role==3){
			$this->custom->updateData("leads",array('l_admin_status'=>1),array('l_id'=>$lid));
		}
		if($this->userdet[0]->u_role==1){
			$this->custom->updateData("leads",array('l_staff_status'=>1),array('l_id'=>$lid));
		}
		$upqry = $this->custom->get_where("leads",array('l_id'=>$lid));
		$docqry = $this->custom->get_where("documents",array('l_id'=>$lid));

		/* $countryapplied = $this->custom->get_where("country",array('id'=>$upqry[0]->l_applied_country));
		$location = $this->custom->get_where("country",array('id'=>$upqry[0]->l_location)); */

		$cname ='';
		if(!empty($countryapplied[0]->cname)){
			$cname = $countryapplied[0]->cname;
		}
		/* $location ='';
		if(!empty($location[0]->cname)){
			$location = $location[0]->cname;
		} */
		
		if($upqry){
			echo '<ul class="nav nav-tabs" id="myTab" role="tablist">
			<li class="nav-item" role="presentation">
			  <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="true">Personal Details</button>
			</li>
			<li class="nav-item" role="presentation">
			  <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false">Academic Details</button>
			</li>
			<li class="nav-item" role="presentation">
			  <button class="nav-link" id="contact-tab" data-bs-toggle="tab" data-bs-target="#contact" type="button" role="tab" aria-controls="contact" aria-selected="false">Miscellaneous</button>
			</li>
		  </ul>
		  <div class="tab-content" id="myTabContent">
			<div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
			<table class="table">
				<tr><td><b>Full Name:</b> '.$upqry[0]->l_fullname.'</td><td><b>Phone Number:</b> '.$upqry[0]->l_phone.'</td></tr>
				<tr><td><b>Email Id :</b> '.$upqry[0]->l_email.'</td><td><b>Applied Country:</b> '.$cname.'</td></tr>
				<tr><td><b>Country / Courses Interested In:</b> '.$upqry[0]->l_interestedIn.'</td><td><b>Date of Birth:</b> '.dateFormat('d/m/Y',$upqry[0]->l_dob).'</td></tr>
				<tr><td><b>Age :</b> '.yearsdiff($upqry[0]->l_dob,date("Y-m-d")).'</td><td><b>Created Date:</b> '.dateFormat('d/m/Y',$upqry[0]->created).'</td></tr>
				<tr><td><b>Pan No :</b> '.$upqry[0]->l_panno.'</td><td><b>Photo:</b> '.$upqry[0]->l_photo.'</td></tr>
				<tr><td><b>Address :</b> '.$upqry[0]->l_address.'</td><td><b>Location:</b> '.$upqry[0]->l_location.'</td></tr>
			</table>
			</div>
			<div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">';
			if(!empty($upqry[0]->board10)){
			echo '<table class="table">
				<thead class="table-success">
				<tr><th colspan="2">Qualification 10th</th></tr>
				</thead>
				<tr><td><b>Board:</b> '.$upqry[0]->board10 .'</td><td><b>Year:</b> '.$upqry[0]->passyear10.'</td></tr>
				<tr><td><b>Percentage :</b> '.$upqry[0]->passperc10.'</td>';
				if(!empty($upqry[0]->upload10)){
				echo '<td><b>Download file :</b> <a href="'.base_url('uploads/leads/'.$upqry[0]->upload10).'" target="_blank">File</a></td>';
				}
				echo '</tr>
				
			</table>';
			}
			if(!empty($upqry[0]->board12)){
				echo '<table class="table">
					<thead class="table-success">
					<tr><th colspan="2">Qualification 12th</th></tr>
					</thead>
					<tr><td><b>Board:</b> '.$upqry[0]->board12 .'</td><td><b>Year:</b> '.$upqry[0]->passyear12.'</td></tr>
					<tr><td><b>Stream :</b> '.$upqry[0]->stream12.'</td><td><b>Percentage :</b> '.$upqry[0]->passperc12.'</td></tr>
					<tr><td><b>English Percentage :</b> '.$upqry[0]->engperc12.'</td>';
					if(!empty($upqry[0]->upload12)){
					echo '<td><b>Download File :</b>  <a href="'.base_url('uploads/leads/'.$upqry[0]->upload12).'" target="_blank">File</a></td>';
					}
					echo '</tr>
					
				</table>';
				}
				if(!empty($upqry[0]->boarddiploma)){
					echo '<table class="table">
					<thead class="table-success">
					<tr><th colspan="2">Diploma</th></tr>
					</thead>
						<tr><td><b>Board:</b> '.$upqry[0]->boarddiploma .'</td><td><b>Year:</b> '.$upqry[0]->passyeardiploma.'</td></tr>
						<tr><td><b>Stream :</b> '.$upqry[0]->streamdiploma.'</td><td><b>Percentage :</b> '.$upqry[0]->passpercdiploma.'</td></tr>
						<tr>';
						if(!empty($upqry[0]->uploaddiploma)){
						echo '<td><b>Download File :</b>  <a href="'.base_url('uploads/leads/'.$upqry[0]->uploaddiploma).'" target="_blank">File</a></td>';
						}
						echo '</tr>
						
					</table>';
					}
					if(!empty($upqry[0]->boardgrad)){
						echo '<table class="table">
						<thead class="table-success">
						<tr><th colspan="2">Graduation</th></tr>
						</thead>
							<tr><td><b>Board:</b> '.$upqry[0]->boardgrad .'</td><td><b>Year:</b> '.$upqry[0]-> 	passyeargrad.'</td></tr>
							<tr><td><b>Stream :</b> '.$upqry[0]->streamgrad.'</td><td><b>Percentage :</b> '.$upqry[0]->passpercgrad.'</td></tr>
							<tr>';
							if(!empty($upqry[0]->uploadgrad)){
							echo '<td><b>Download File :</b>  <a href="'.base_url('uploads/leads/'.$upqry[0]->uploadgrad).'" target="_blank">File</a></td>';
							}
							echo '</tr>
							
						</table>';
						}
					if(!empty($upqry[0]->boardpg)){
						echo '<table class="table">
						<thead class="table-success">
						<tr><th colspan="2">Post Graduation</th></tr>
						</thead>
							<tr><td><b>Board:</b> '.$upqry[0]->boardpg .'</td><td><b>Year:</b> '.$upqry[0]->passyearpg.'</td></tr>
							<tr><td><b>Stream :</b> '.$upqry[0]->streampg.'</td><td><b>Percentage :</b> '.$upqry[0]->passpercpg.'</td></tr>
							<tr>';
							if(!empty($upqry[0]->uploadpg)){
							echo '<td><b>Download File :</b>  <a href="'.base_url('uploads/leads/'.$upqry[0]->uploadpg).'" target="_blank">File</a></td>';
							}
							echo '</tr>
							
						</table>';
						}
					if(!empty($upqry[0]->overallielts)){
						/* echo '<table class="table">
						<thead class="table-success">
						<tr><th colspan="2">IELTS</th></tr>
						</thead>
							<tr><td><b>Over All:</b> '.$upqry[0]->overallielts .'</td><td><b>Listening:</b> '.$upqry[0]->listeningielts.'</td></tr>
							<tr><td><b>Writing :</b> '.$upqry[0]->writingielts.'</td><td><b>Reading :</b> '.$upqry[0]->readingielts.'</td></tr>
							<tr><td><b>Speaking :</b> '.$upqry[0]->seakingielts .'</td>';
							if(!empty($upqry[0]->uploadielts)){
							echo '<td><b>Download File :</b>  <a href="'.base_url('uploads/leads/'.$upqry[0]->uploadielts).'" target="_blank">File</a></td>';
							}
							echo '</tr>
							
						</table>'; */
						}
					if(!empty($upqry[0]->overallpte)){
						/* echo '<table class="table">
						<thead class="table-success">
						<tr><th colspan="2">PTE</th></tr>
						</thead>
							<tr><td><b>Over All:</b> '.$upqry[0]->overallpte .'</td><td><b>Listening:</b> '.$upqry[0]->listingpte.'</td></tr>
							<tr><td><b>Writing :</b> '.$upqry[0]->writingpte.'</td><td><b>Reading :</b> '.$upqry[0]->readingpte.'</td></tr>
							<tr><td><b>Speaking :</b> '.$upqry[0]->speakingpte .'</td>';
							if(!empty($upqry[0]->uploadpte)){
							echo '<td><b>Download File :</b>  <a href="'.base_url('uploads/leads/'.$upqry[0]->uploadpte).'" target="_blank">File</a></td>';
							}
							echo '</tr>
							
						</table>'; */
						}
					if(!empty($upqry[0]->overallduolingo)){
						/* echo '<table class="table">
						<thead class="table-success">
						<tr><th colspan="2">Duolingo</th></tr>
						</thead>
							<tr><td><b>Over All:</b> '.$upqry[0]->overallduolingo .'</td><td><b>Listening:</b> '.$upqry[0]->listingduolingo.'</td></tr>
							<tr><td><b>Writing :</b> '.$upqry[0]->writingduolingo.'</td><td><b>Reading :</b> '.$upqry[0]->readingduolingo.'</td></tr>
							<tr><td><b>Speaking :</b> '.$upqry[0]->speakingduolingo .'</td>';
							if(!empty($upqry[0]->uploadduolingo)){
							echo '<td><b>Download File :</b>  <a href="'.base_url('uploads/leads/'.$upqry[0]->uploadduolingo).'" target="_blank">File</a></td>';
							}
							echo'</tr>
							
						</table>'; */
						}
						if(!empty($upqry[0]->overallany)){
							/* echo '<table class="table">
							<thead class="table-success">
							<tr><th colspan="2">Duolingo</th></tr>
							</thead>
								<tr><td><b>Over All:</b> '.$upqry[0]->overallany .'</td><td><b>Listening:</b> '.$upqry[0]->listingany.'</td></tr>
								<tr><td><b>Writing :</b> '.$upqry[0]->writingany.'</td><td><b>Reading :</b> '.$upqry[0]->readingany.'</td></tr>
								<tr><td><b>Speaking :</b> '.$upqry[0]->speakingany .'</td>';
								if(!empty($upqry[0]->uploadany)){
								echo '<td><b>Download File :</b>  <a href="'.base_url('uploads/leads/'.$upqry[0]->uploadany).'" target="_blank">File</a></td>';
								}
								echo'</tr>
								
							</table>'; */
							}
							if(!empty($upqry[0]->overallany)){
								/* echo '<table class="table">
								<thead class="table-success">
								<tr><th colspan="2">Duolingo</th></tr>
								</thead>
									<tr><td><b>Over All:</b> '.$upqry[0]->overallany .'</td><td><b>Listening:</b> '.$upqry[0]->listingany.'</td></tr>
									<tr><td><b>Writing :</b> '.$upqry[0]->writingany.'</td><td><b>Reading :</b> '.$upqry[0]->readingany.'</td></tr>
									<tr><td><b>Speaking :</b> '.$upqry[0]->speakingany .'</td>';
									if(!empty($upqry[0]->uploadany)){
									echo '<td><b>Download File :</b>  <a href="'.base_url('uploads/leads/'.$upqry[0]->uploadany).'" target="_blank">File</a></td>';
									}
									echo'</tr>
									
								</table>'; */
								}
			echo '</div>
			
			
			<div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">';
			/* if(!empty($upqry[0]->sop) || !empty($upqry[0]->resume) || !empty($upqry[0]->applicationform) || !empty($upqry[0]->workreference) || !empty($upqry[0]->otherdcos)){ */
				echo '<div>';
				if($docqry){
						$s=1;
						$e=1;
						$sop ='';
						$education ='';
						foreach($docqry as $docres){
							if($docres->sop==1){
								$sop .='<a href="'.base_url('uploads/documents/'.$docres->d_file).'" target="_blank">File'.$s.'</a> ';
								$s++;
							}
							echo '<div style="clear:both;"></div>';
							if($docres->education==1){
								$education .= '<a href="'.base_url('uploads/documents/'.$docres->d_file).'" target="_blank">File'.$e.'</a> ';
								$e++;
							}
						}
						echo '<div style=""><b>Education :</b>'.$education.'</div>';
						echo '<div style=""><b>Documents :</b>'.$sop.'</div>';
					}
					
					/* if(!empty($upqry[0]->sop)){
					echo '<td><b>Download SOP :</b>  <a href="'.base_url('uploads/leads/'.$upqry[0]->sop).'" target="_blank">File</a></td>';
					}
					if(!empty($upqry[0]->resume)){
						echo '<td><b>Download Resume :</b>  <a href="'.base_url('uploads/leads/'.$upqry[0]->resume).'" target="_blank">File</a></td>';
					}
					if(!empty($upqry[0]->applicationform)){
						echo '<td><b>Download Application Form :</b>  <a href="'.base_url('uploads/leads/'.$upqry[0]->applicationform).'" target="_blank">File</a></td>';
					}
					if(!empty($upqry[0]->workreference)){
						echo '<td><b>Download Work Reference :</b>  <a href="'.base_url('uploads/leads/'.$upqry[0]->workreference).'" target="_blank">File</a></td>';
					}
					if(!empty($upqry[0]->otherdcos)){
						echo '<td><b>Download Other document :</b>  <a href="'.base_url('uploads/leads/'.$upqry[0]->otherdcos).'" target="_blank">File</a></td>';
					} */
					echo'</div>';
				/* } */
			
			echo '</div>
		  </div>
		  ';
		}else{
			echo '<div class="alert alert-danger">Something went wrong. Please try again.</div>';
		}
		
			
		
	}

	public function ajax_reject()
	{
		$action = $this->uri->segment(3);
		$id = $this->uri->segment(4);
		
		$lid = $this->input->post('lid');
		$reject_comment = $this->input->post('reject_comment');
		
		$data = array(); $return = array();
		
		$states = $this->custom->get_where('states',array('c_id'=>$cval));
		foreach($states as $state){
			$data['id']=$state->id;
			$data['name']=$state->sname;
			
			array_push($return,$data);
		}
		echo json_encode($return);
		
			
		
	}


	public function import() {

			$path = FCPATH . "uploads/csv";

			$config['upload_path'] = $path;
			$config['allowed_types'] = 'csv';
			$config['max_size'] = 1024000;
			$this->load->library('upload', $config);

			$this->upload->initialize($config);

			if (!$this->upload->do_upload('file')) {
				$error = $this->upload->display_errors();

				$this->session->set_flashdata('error', $this->upload->display_errors());
				redirect("sadmin/documents");
				//echo $error['error'];
			} else {

				$file_data = $this->upload->data();
				$file_path = base_url() . "uploads/csv/" . $file_data['file_name'];
				/* $file_path = "./uploads/csv/" . $file_data['file_name']; */

				$csv_data = $this->csvimport->parse_file($file_path);
				/* print_r($csv_data); exit; */
			// Add created and modified date if not include
				$date = date("Y-m-d H:i:s");

				if ($csv_data) {
					
					foreach ($csv_data as $row) {

						$insert_data[] = array(
								'u_name' => $row['University'],
								'u_country' => $row['Country'],
								'u_courses' => $row['Course'],
								'u_location' => $row['Location'],
								'u_academic' => $row['Academic'],
								'u_english' => $row['English'],
								'u_intake' => $row['Intake'],
								'u_region' => $row['Region'],
								'created' => $date,
								'modified' => $date,
						);
				
					}

					if($insert_data){
						foreach($insert_data as $ky=>$row){
							$insar = array(
								'u_name' => $row['u_name'],
								'u_country' => $row['u_country'],
								'u_courses' => $row['u_courses'],
								'u_location' => $row['u_location'],
								'u_academic' => $row['u_academic'],
								'u_english' => $row['u_english'],
								'u_intake' => $row['u_intake'],
								'u_region' => $row['u_region'],
								'created' => $date,
								'modified' => $date,
							);

							$rescnt = $this->custom->get_where("univ_docs" , array('u_name'=>$row['u_name'],'u_country'=>$row['u_country'],'u_courses'=>$row['u_courses'],'u_location'=>$row['u_location']));

							if(count($rescnt)==0){
								$insert = $this->custom->insert('univ_docs',$insar); 
							}
						}
					}
					
			/* $this->custom->insert_batch("univ_docs",$insert_data); */
			$this->session->set_flashdata('success', "Csv imported successfully");
					redirect("sadmin/documents");

				} else {
					$data['error'] = "Error occured";
					$this->session->set_flashdata('error', $data['error']);
					redirect("sadmin/documents");
				}
				
			}
		} 


		public function send_mail($to_email,$from_email, $from_name,$subject,$email_template,$message_data) { 
			
			//Load email library 
			$this->load->library('email'); 
	  
			$this->email->from($from_email, $from_name); 
			$this->email->to($to_email);
			$this->email->subject($subject); 
			
			$this->email->message($this->load->view('admin/'.$email_template,$message_data, true)); 
			$this->email->set_mailtype('html');
			//Send mail 
			if($this->email->send()){
				return true;
			}else{
				return false;
			}
			 
		 } 
	
}