<?php

if(!function_exists('dateFormat'))
{
    function dateFormat($format='d-m-Y', $givenDate=null)
    {
        return date($format, strtotime($givenDate));
    }
}

if(!function_exists('yearsdiff'))
{
    function yearsdiff($from, $to)
    {
        return date_diff(date_create($from), date_create($to))->y;
    }
}

if ( ! function_exists('asset_url'))
{
    function asset_url($path = '')
    {
        $CI =& get_instance();
        return ASSETS_URL . ltrim($path, '/');
    }
}

if(!function_exists('pr'))
{
    function pr($givenArray=null)
    {
		echo "<pre>";
        print_r($givenArray);
		echo "</pre>";
    }
}

if(!function_exists('qry'))
{
    function qry()
    {
		$ci =& get_instance();
		echo $ci->db->last_query();
		exit;
    }
}

if(!function_exists('cleanArray'))
{
    function cleanArray($arraydata)
    {
		$cleanarray = array();
		foreach($arraydata as $key => $value){
			if(is_array($value)){
				foreach($value as $ky => $val){
					$cleanarray[$key][$ky] = strip_tags($val);
				}

			}else{
				$cleanarray[$key] = strip_tags($value);
			}
		}
		return $cleanarray;
    }
}




if(!function_exists('insertQry'))
{
    function insertQry($table,$rowData)
    {
		$ci =& get_instance();
		 
		if($ci->form_validation->run() == true){ 
			$insert = $ci->custom->insert($table,$rowData); 
			if($insert){ 
				$ci->session->set_flashdata('error_msg', INSERT);
				return true;
			}else{ 
				$ci->session->set_flashdata('error_msg', WRONG);
				return false;
			} 
		}else{ 
			$ci->session->set_flashdata('error_msg', EMPTY_FORM);
			return false;
		}
    }
}


if(!function_exists('updateQry'))
{
    function updateQry($table,$rowData,$where)
    {
		$ci =& get_instance();
		 
		if($ci->form_validation->run() == true){ 
			$update = $ci->custom->updateData($table,$rowData,$where); 
			
			if($update){ 
				$ci->session->set_flashdata('error_msg', UPDATE);
				return true;
			}else{ 
				$ci->session->set_flashdata('error_msg', WRONG);
				return false;
			} 
		}else{ 
			$ci->session->set_flashdata('error_msg', EMPTY_FORM);
			return false;
		}
		
    }
}


if(!function_exists('getTableInfo'))
{
    function getTableInfo($db,$table,$where=array())
    {
		$ci =& get_instance();
		
		$tableinfo = $ci->db->query("SELECT `COLUMN_NAME` FROM `INFORMATION_SCHEMA`.`COLUMNS` WHERE `TABLE_SCHEMA`='".$db."' AND `TABLE_NAME`='".$table."'");

		$rescol = $tableinfo->result();
		if($where){
			$tblrow = $ci->custom->get_where($table,$where);
			foreach($rescol as $rcol)
			{
				$fieldname = $rcol->COLUMN_NAME;
				/* $ci->data[$fieldname] = (!empty($tblrow[0]->$fieldname)?$tblrow[0]->$fieldname:''); */
				$ci->data[$fieldname] = (($tblrow[0]->$fieldname!='')?$tblrow[0]->$fieldname:'');
			}
		}else{
			foreach($rescol as $rcol)
			{
				$fieldname = $rcol->COLUMN_NAME;
				$ci->data[$fieldname] = '';
			}
		}
    }
}


if(!function_exists('getCaptcha'))
{
    function getCaptcha()
    {
		$ci =& get_instance();
		
				$vals = array(
					/* 'word'          => 'Random word', */
					'img_path'      => './captcha/',
					'img_url'       => base_url().'captcha/',
					'font_path'     => './fonts/open-sans/OpenSans-Bold.ttf',
					'img_width'     => '150',
					'img_height'    => 30,
					'expiration'    => 7200,
					'word_length'   => 4,
					'font_size'     => 16, 
					'img_id'        => 'Imageid',
					'pool'          => '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ',
			
					// White background and border, black text and red grid
							'colors'   => array(
								'background' => array(255, 255, 255),
								'border' => array(255, 255, 255),
								'text' => array(0, 0, 0),
								'grid' => array(255, 40, 40)
							)
			);

			
			
			$cap = create_captcha($vals);
			return  $cap['image'];

			$data = array(
					'captcha_time'  => $cap['time'],
					'ip_address'    => $ci->input->ip_address(),
					'word'          => $cap['word']
			);
			
			$query = $ci->db->insert_string('captcha', $data);
			$ci->db->query($query);
    }
}



if(!function_exists('fileupload'))
{
    function fileupload($upload_param = array())
    {
		$ci =& get_instance();

		$new_name = '';
		$new_name = time() . '_' . $_FILES[$upload_param['filename']]['name'];
		$config['file_name'] = $new_name;


/*		if(array_key_first($upload_param)){
*/
			
			$config['upload_path']   = './uploads/'.$upload_param['path']; 
			$config['allowed_types'] = $upload_param['types']; 
			$config['max_size']      = $upload_param['size']; 
			/* $config['max_width']     = $upload_param['width']; 
			$config['max_height']    = $upload_param['height']; */  
	/*	}else{
			$config['upload_path']   = './uploads/'; 
			$config['allowed_types'] = 'gif|jpg|png'; 
			$config['max_size']      = 1024; 
			
			
		}	*/

		$ci->load->library('upload', $config);
		$ci->upload->initialize($config);
		$filestatus = array();
         if ( ! $ci->upload->do_upload($upload_param['filename'])) {
            $error = array('error' => $ci->upload->display_errors()); 
            $filestatus['error'] =  1;
            $filestatus['status'] =  $error;
         }
			
         else { 
				$field = $upload_param['field'];
				$file_data = $ci->custom->get_where($upload_param['table'], array($upload_param['pkfield']=> $upload_param['pkval']));
				
				if(!empty($file_data[0]->$field)){
					unlink($config['upload_path']."/".$file_data[0]->$field);
				}

            $updata = array('upload_data' => $ci->upload->data()); 
			$filestatus['error'] =  0;
            $filestatus['status'] = $updata;

			/* $up_img = array(
				$upload_param['field'] =>$ci->data['updata']['upload_data']['file_name'],
			); */
			$up_img = array(
				$upload_param['field'] =>$updata['upload_data']['file_name'],
			);
			$ci->custom->updateData($upload_param['table'], $up_img,array($upload_param['pkfield']=> $upload_param['pkval']));
			
         } 

		 return $filestatus;
    }
}

