<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Custom extends CI_Model {

	public function __construct(){
		parent::__construct();
	}


    function insert_batch($table,$data) {
        $this->db->insert_batch($table, $data);
    }

	public function getSettings(){

		$response = array();

		// Select record
		$this->db->select('*');
		$q = $this->db->get('settings');
		$response = $q->result();

		return $response;
	}


    /* public function getFileno($uid){

		$response = array();

		$q = $this->db->query("select * from leads ");
		$response = $q->result();

		return $response;
	} */
  
	public function insertData($table,$data){
		$this->db->insert($table,$data);
	}

	public function updateData($table,$data,$where){
		$this->db->where($where);
		$query = $this->db->update($table,$data);
		if ($this->db->affected_rows() > 0){
		  return TRUE;
		}else{
		  return FALSE;
		}
	}


	public function get_data($table){
		$query = $this->db->get($table);
		return $query->result();
	}
	public function get_where($table,$where){
		$query = $this->db->get_where($table,$where);
		return $query->result();
	}

    public function query($query){
		$query = $this->db->query($query);
		return $query->result();
	}

    public function delete_where($tablename, $where) {
        if ($where) {
            $this->db->where($where);
        }

        if ($this->db->delete($tablename)) {
            return true;
        }
        return false;
    }
	
	
    public function getRows($table, $params = array(),$primarykey="",$primaryval=""){ 
        $this->db->select('*'); 
        $this->db->from($table); 
         
        if(array_key_exists("conditions", $params)){ 
            foreach($params['conditions'] as $key => $val){ 
                $this->db->where($key, $val); 
            } 
        } 
         
        if(array_key_exists("returnType",$params) && $params['returnType'] == 'count'){ 
            $result = $this->db->count_all_results(); 
        }else{ 
            if(!empty($primarykey) || $params['returnType'] == 'single'){ 
                if(!empty($primaryval)){ 
                    $this->db->where($primarykey, $primaryval); 
                } 
                $query = $this->db->get(); 
                $result = $query->row_array(); 
            }else{ 
                $this->db->order_by($primarykey, 'desc'); 
                if(array_key_exists("start",$params) && array_key_exists("limit",$params)){ 
                    $this->db->limit($params['limit'],$params['start']); 
                }elseif(!array_key_exists("start",$params) && array_key_exists("limit",$params)){ 
                    $this->db->limit($params['limit']); 
                } 
                 
                $query = $this->db->get(); 
                $result = ($query->num_rows() > 0)?$query->result_array():FALSE; 
            } 
        } 
         
        // Return fetched data 
        return $result; 
    } 
     
    /* 
     * Insert user data into the database 
     * @param $data data to be inserted 
     */ 
    public function insert($table,$data = array()) { 
        if(!empty($data)){ 
            // Add created and modified date if not included 
            if(!array_key_exists("created", $data)){ 
                $data['created'] = date("Y-m-d H:i:s"); 
            } 
            if(!array_key_exists("modified", $data)){ 
                $data['modified'] = date("Y-m-d H:i:s"); 
            } 
             
            // Insert member data 
            $insert = $this->db->insert($table, $data); 
             
            // Return the status 
            return $insert?$this->db->insert_id():false; 
        } 
        return false; 
    } 


}