<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Agent extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	 public function __construct()
	 {

		parent::__construct();
		
		$this->dbname = $this->db->database;
		$this->data['settings'] = $this->custom->getSettings();

		$this->data['uid'] = $this->session->userdata('userId');
		
		// User login status 
        $this->isUserLoggedIn = $this->session->userdata('isUserLoggedIn');
		$this->data['isUserLoggedIn'] = $this->isUserLoggedIn;
		
		$this->clink = $this->uri->segment('1');
		$this->data['clink'] = $this->clink;
		
		if(empty($this->isUserLoggedIn)){
			if($this->uri->segment('2')!='login' && $this->uri->segment('2')!='register'){
				redirect('agency/login'); 
			}
		}

		$this->data['lang'] = $this->session->userdata('site_lang');

		if(!empty($this->isUserLoggedIn)){
			if($this->session->userdata('userType')=='1'){
                $this->data['myaccountLink'] = base_url('agency/dashboard');
            }else{
                $this->data['myaccountLink'] = base_url('candidate/dashboard');
            }
		}
		
		$this->countries = $this->custom->get_data('country');
		$this->data['countries'] = $this->countries;
		
		$this->userinfo = $this->custom->get_where('users',array('u_id'=>$this->data['uid']));
		$this->data['userinfo'] = $this->userinfo;

		if(!empty($this->userinfo[0]->u_a_company_logo)){
			$this->data['company_logo'] = $this->userinfo[0]->u_a_company_logo;
		}else{
			$this->data['company_logo'] = 'nologo.jpg';
		}
		
		
		$gender = $this->config->item('gender'); 	$this->data['gender'] = $gender;
		$jobtype = $this->config->item('jobtype'); 	$this->data['jobtype'] = $jobtype;
		$serchexp = $this->config->item('serchexp'); 	$this->data['serchexp'] = $serchexp;
		$marital = $this->config->item('marital'); 	$this->data['marital'] = $marital;
		$religion = $this->config->item('religion'); 	$this->data['religion'] = $religion;
		$mr = $this->config->item('mr'); 	$this->data['mr'] = $mr;
		$qualification = $this->config->item('qualification'); 	$this->data['qualification'] = $qualification;
		$appliedstatus = $this->config->item('appliedstatus'); 	$this->data['appliedstatus'] = $appliedstatus;
		$search_salary = $this->config->item('search_salary'); 	$this->data['search_salary'] = $search_salary;


		$pagesection = $this->uri->segment(2);

		if($pagesection=='dashboard'){ $this->data['dashcls']='active';}else{ $this->data['dashcls']='';}
		if($pagesection=='post_job'){ $this->data['pjcls']='active';}else{ $this->data['pjcls']='';}
		if($pagesection=='all_jobs'){ $this->data['ajcls']='active';}else{ $this->data['ajcls']='';}
		if($pagesection=='logout'){ $this->data['lgcls']='active';}else{ $this->data['lgcls']='';}
		if($pagesection=='search_candidates'){ $this->data['sccls']='active';}else{ $this->data['sccls']='';}
		if($pagesection=='edit_profile'){ $this->data['epcls']='active';}else{ $this->data['epcls']='';}
		if($pagesection=='invited_candidates'){ $this->data['iccls']='active';}else{ $this->data['iccls']='';}
		if($pagesection=='applications'){ $this->data['apcls']='active';}else{ $this->data['apcls']='';}
		
	  }

	 
	public function index()
	{
		
		if($this->isUserLoggedIn){ 
            redirect('agency/dashboard'); 
        }else{ 
            redirect('agency/login'); 
        } 
		
	}
	
	public function login(){ 
       /*  $data = array();  */
         
         
        // If login request submitted 
        if($this->input->post('loginSubmit')){ 
            $this->form_validation->set_rules('username', 'Email', 'required'); 
            $this->form_validation->set_rules('password', 'password', 'required'); 
             
            if($this->form_validation->run() == true){ 
                $where = array( 
                    'returnType' => 'single', 
                    'conditions' => array( 
                        'u_userid'=> $this->input->post('username'), 
                        'u_pass' => md5($this->input->post('password')), 
                        'u_status' => 1, 
                        'u_usertype' => 1 
                    ) 
                ); 
                $checkLogin = $this->custom->getRows('users',$where);
				if($checkLogin){ 
					if($checkLogin['u_userid']==$this->input->post('username') && $checkLogin['u_pass']==md5($this->input->post('password')))
					{
						$this->session->set_userdata('isUserLoggedIn', TRUE); 
						$this->session->set_userdata('userId', $checkLogin['u_id']); 
						$this->session->set_userdata('userType', $checkLogin['u_usertype']); 
						redirect('agency/dashboard','refresh'); 
					}else{
						$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">Wrong Username or password, please try again.</div>');
						
					}
                }else{ 
                    $this->session->set_flashdata('error_msg', '<div class="alert alert-danger">Wrong Username or password, please try again.</div>');
                } 
            }else{ 
				$this->session->set_flashdata('error_msg', '<div class="alert alert-warning">Please fill all the mandatory fields.</div>');
                
            } 
        } 
         
        // Load view 
        $this->load->agency_view('login', $this->data); 
        
    } 
	
	public function register(){ 
       /*  $data = $userData = array();  */
         
        // If registration request is submitted 
        if($this->input->post('signupSubmit')){ 
            $this->form_validation->set_rules('u_userid', 'User Id', 'required|is_unique[users.u_userid]'); 
            $this->form_validation->set_rules('u_a_email', 'Email', 'required|valid_email|callback_email_check'); 
            $this->form_validation->set_rules('u_a_comp_name', 'Agency Name', 'required'); 
            $this->form_validation->set_rules('password', 'password', 'required'); 

			$this->form_validation->set_message('is_unique', 'The %s is already taken');
            /* $this->form_validation->set_rules('conf_password', 'confirm password', 'required|matches[password]');  */
 
            $userData = array( 
                'u_userid' => strip_tags($this->input->post('u_userid')), 
                'u_a_ra_id' => strip_tags($this->input->post('u_userid')), 
                'u_pass' => md5($this->input->post('password')), 
                'u_a_comp_name' => strip_tags($this->input->post('u_a_comp_name')), 
                'u_a_cp_mobile' => strip_tags($this->input->post('u_a_cp_mobile')), 
                'u_a_email' => strip_tags($this->input->post('u_a_email')), 
                'u_usertype' => 1, 
                'u_ipaddress' => $this->input->ip_address(), 
                
            ); 
 
            if($this->form_validation->run() == true){ 
                $insert = $this->custom->insert('users',$userData); 
                if($insert){ 
					$insert_id = $insert;
					/* $insert = $this->custom->insert('work_experience',array('u_id'=>$insert_id));  */
				
                    $this->session->set_flashdata('error_msg', '<div class="alert alert-success">Your account registration has been successful. Please login to your account.</div>');
					redirect('agency/dashboard','refresh'); 
                }else{ 
					$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">Some problems occured, please try again.</div>');
					redirect('agency/login#register','refresh'); 
                    
                } 
            }else{ 
				$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">'.validation_errors().'</div>');
				redirect('agency/login#register','refresh'); 
                
            } 
        } 
         
       
    } 
     
    public function logout(){ 
        $this->session->unset_userdata('isUserLoggedIn'); 
        $this->session->unset_userdata('userId'); 
        $this->session->sess_destroy(); 
        redirect('agency/login'); 
    } 
     
     
    // Existing email check during validation 
    public function email_check($str){ 
        $con = array( 
            'returnType' => 'count', 
            'conditions' => array( 
                'u_s_email' => $str 
            ) 
        ); 
        $checkEmail = $this->custom->getRows('users',$con); 
        if($checkEmail > 0){ 
            $this->form_validation->set_message('email_check', 'The given email already exists.'); 
            return FALSE; 
        }else{ 
            return TRUE; 
        } 
    } 
	
	public function dashboard()
	{
		if(isset($_SESSION['error_msg'])){
			unset($_SESSION['error_msg']);
		}
		
		$this->joblists = $this->custom->get_where('post_job',array('u_id'=>$this->userinfo[0]->u_id));
		$this->data['restot'] = $this->custom->query("select count(p_id) as totjobs from post_job where u_id = '".$this->userinfo[0]->u_id."'");


		$this->data['invtot'] = $this->custom->query("select count(sj_id) as tot from stu_saved_applied_jobs where agency_id = '".$this->data['uid']."' and sj_status=3");

		$this->data['joblists'] = $this->joblists;
		
		$this->load->agency_inner_view('dashboard',$this->data);
	}
	
	public function personal_info()
	{
		if($this->input->post('savepersonalinfo')){
			
			$this->form_validation->set_rules('u_s_fname', 'First Name', 'required'); 
            $this->form_validation->set_rules('u_s_lname', 'Last Name', 'required'); 
            $this->form_validation->set_rules('u_s_mobile', 'Mobile Number', 'required'); 
            $this->form_validation->set_rules('u_s_dob', 'Date of Birth', 'required'); 
            $this->form_validation->set_rules('u_s_gender', 'Gender', 'required'); 
            /* $this->form_validation->set_rules('conf_password', 'confirm password', 'required|matches[password]');  */
 
           $userData = cleanArray($this->input->post());
		   
		   $userData['modified']= date("Y-m-d H:i:s"); 
		   unset($userData['savepersonalinfo']);
		   
		   if(updateQry('users',$userData,array('u_id'=>$this->userinfo[0]->u_id))){
			   redirect('agency/personal_info'); 
		   }else{
				foreach($userData as $ky => $vl){
					$this->data[$ky] = $vl;
				}
		   }
		}else{
			getTableInfo($this->dbname,'users',array('u_id'=>$this->userinfo[0]->u_id));
		}
		$this->load->agency_view('personal_info',$this->data);
	}
	
	public function post_job()
	{
		if($this->input->post('savepostjob')){
			
			$this->form_validation->set_rules('p_job_title', 'Job Title', 'required'); 
            $this->form_validation->set_rules('p_company_name', 'Company Name', 'required'); 
        
           $rowData = cleanArray($this->input->post());
		   
		   $rowData['modified']= date("Y-m-d H:i:s"); 
		   $rowData['u_id']= $this->userinfo[0]->u_id; 
		   $rowData['p_status']= 1; 
		   unset($rowData['savepostjob']);
		   
		   if(insertQry('post_job',$rowData)){
			   redirect('agency/post_job'); 
		   }else{
				foreach($rowData as $ky => $vl){
					$this->data[$ky] = $vl;
				}
		   }
		}else{
			getTableInfo($this->dbname,'post_job');
		
		}

		
		
		$this->data['countries'] = $this->custom->get_data('country');
		$this->data['categories'] = $this->custom->get_where('jobspecialization',array('js_status'=>1));
		$this->userexp = $this->custom->get_where('post_job',array('u_id'=>$this->userinfo[0]->u_id));
		$this->data['userexp'] = $this->userexp;
		$this->load->agency_inner_view('post_job',$this->data);
	}

	public function all_jobs()
	{
		
		
		$this->jobslist = $this->custom->get_where('post_job',array('u_id'=>$this->userinfo[0]->u_id));
		$this->data['jobslist'] = $this->jobslist;
		$this->load->agency_inner_view('all_jobs',$this->data);
	}


	public function invited_candidates()
	{
		
		
		$this->invitelist = $this->custom->get_where('stu_saved_applied_jobs',array('agency_id'=>$this->userinfo[0]->u_id,'sj_status'=>3));
		$this->data['invitelist'] = $this->invitelist;
		$this->load->agency_inner_view('invited_candidates',$this->data);
	}

	public function applications()
	{
		
		
		$this->applicationslist = $this->custom->get_where('stu_saved_applied_jobs',array('agency_id'=>$this->userinfo[0]->u_id,'sj_status'=>1));
		$this->data['applicationslist'] = $this->applicationslist;
		$this->load->agency_inner_view('applications',$this->data);
	}
	

	public function applied_candidates()
	{
		$pid = $this->uri->segment('3');
		
		$this->data['job'] = $this->custom->get_where('post_job',array('p_id'=>$pid));
		
		$this->appliedlist = $this->custom->query("select * from stu_saved_applied_jobs ssa, users u where ssa.u_id=u.u_id and ssa.p_id='".$pid."' and ssa.sj_status='1' ");
		$this->data['appliedlist'] = $this->appliedlist;
		$this->load->agency_inner_view('applied_candidates',$this->data);
	}



	public function search_candidates()
	{
		$this->data['srchcountry'] ='';
		$this->data['searchkey'] =array();
		if($this->input->post('advsearch')){
			 $searchkey = $this->input->post('searchkey');
			$this->data['searchkey'] = $searchkey;

			$country = $this->input->post('search_country');
			$this->data['srchcountry'] = $country;

			
			$searchqry ='';

			if(!empty($searchkey)){
				$i=1;
				$searchqry .=" and ( ";
				foreach($searchkey as $searchkey){
					if($i>1){
						$searchqry .=" or ";
					}
					$searchqry .=" FIND_IN_SET('$searchkey',jp.s_skills) ";	
					
					$i++;
				}
				$searchqry .=" ) ";
				/* $searchqry .=" and (u_s_fname like '%".$searchkey."%' or u_s_mname like '%".$searchkey."%' or u_s_lname like '%".$searchkey."%' )"; */
			}

			if(!empty($country)){
				$searchqry .=" and jp.jp_location = '".$country."' ";
			}

			$this->data['users'] = $this->custom->query("Select *  from users u, job_preference jp where u.u_usertype='2' and u.u_id=jp.u_id   $searchqry ");
			
		}
		else{
			$this->users = $this->custom->get_where('users',array('u_usertype'=>2));
			$this->data['users'] = $this->users;
		}

		
		/* $this->data['jobslist'] = $this->custom->get_where('post_job',array('u_id'=>$this->data['uid'])); */
		$this->data['countries'] = $this->custom->get_data('country');
		$this->data['jobspecialization'] = $this->custom->get_where('jobspecialization',array('js_status'=>1,'js_featured'=>1));
		$this->data['skills'] = $this->custom->get_data('skills');
		$this->data['jobslist'] = $this->custom->get_where('post_job',array('u_id'=>$this->data['uid']));
		
		$funcareares = $this->custom->query('select count(u_id) as tot,jp_func_area from job_preference group by jp_func_area');

		$this->data['funcarea_arry'] = array();
		$funcarea_arry = array();
		if($funcareares){
			foreach($funcareares as $funcareares){
				$funcarea_arry[$funcareares->jp_func_area] = $funcareares->tot;
			}
			$this->data['funcarea_arry'] = $funcarea_arry;
		}


		$expjp = $this->custom->query('select count(u_id) as tot,jp_exp from job_preference group by jp_exp');

		$this->data['exp_arry'] = array();
		$exp_arry = array();
		if($expjp){
			foreach($expjp as $expjp){
				$exp_arry[$expjp->jp_exp] = $expjp->tot;
			}
			$this->data['exp_arry'] = $exp_arry;
		}

		$salaryjp = $this->custom->query('select count(u_id) as tot,jp_salary from job_preference group by jp_salary');

		$this->data['salaryjp'] = array();
		$salaryjp = array();
		if($salaryjp){
			foreach($salaryjp as $salaryjp){
				$exp_arry[$salaryjp->jp_exp] = $salaryjp->tot;
			}
			$this->data['salaryjp'] = $salaryjp;
		}



		$this->load->agency_view('search_candidates',$this->data);
	}


	public function edit_profile()
	{
		$table = "users";

		if($this->input->post('updateprofile')){
			
			$this->form_validation->set_rules('u_a_comp_name', 'Company Name', 'required'); 
           /*  $this->form_validation->set_rules('u_a_contact_person', 'Representative Name', 'required');  */
        
           $rowData = cleanArray($this->input->post());
		   
		   $rowData['modified']= date("Y-m-d H:i:s"); 
		   unset($rowData['updateprofile']);
		   
		   if(updateQry($table,$rowData,array('u_id'=>$this->data['uid']))){
				
			/* logo upload */
			if(!empty($this->input->post('u_a_company_logo'))){
				$upload_param['filename'] = 'u_a_company_logo';
				$upload_param['path'] = 'agency';
				$upload_param['types'] = 'gif|jpg|png';
				$upload_param['size'] = '2048';
				$upload_param['width'] = '1024';
				$upload_param['height'] = '768';
				$upload_param['table'] = $table;
				$upload_param['field'] = 'u_a_company_logo';
				$upload_param['pkfield'] = 'u_id';
				$upload_param['pkval'] = $this->data['uid'];
				
				$filestaus = fileupload($upload_param);
				if($filestaus['error']==1){
					$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">File format not supported.</div>');
				}else{
					$this->session->set_flashdata('error_msg', '<div class="alert alert-success">File has been uploaded.</div>');
				}
			}

			if(!empty($this->input->post('u_a_ra_licence_file'))){

				/* ra license upload */
				$upload_param['filename'] = 'u_a_ra_licence_file';
				$upload_param['path'] = 'agency';
				$upload_param['types'] = 'gif|jpg|png';
				$upload_param['size'] = '2048';
				$upload_param['width'] = '1024';
				$upload_param['height'] = '768';
				$upload_param['table'] = $table;
				$upload_param['field'] = 'u_a_ra_licence_file';
				$upload_param['pkfield'] = 'u_id';
				$upload_param['pkval'] = $this->data['uid'];
				
				$filestaus = fileupload($upload_param);
				if($filestaus['error']==1){
					$this->session->set_flashdata('error_msg', '<div class="alert alert-danger">File format not supported.</div>');
				}else{
					$this->session->set_flashdata('error_msg', '<div class="alert alert-success">File has been uploaded.</div>');
				}
			}
			  redirect('agency/edit_profile');
		   }else{
				foreach($rowData as $ky => $vl){
					$this->data[$ky] = $vl;
				}
		   }
		}else{
			getTableInfo($this->dbname,$table,array('u_id'=>$this->data['uid']));
			
		}
		
		$this->data['countries'] = $this->custom->get_data('country');
		$this->data['states'] = $this->custom->get_where('states',array('c_id'=>$this->data['u_a_country']));
		$this->users = $this->custom->get_where($table,array('u_usertype'=>2));
		$this->data['users'] = $this->users;
		
		$this->load->agency_inner_view('edit_profile',$this->data);
	}
	
	


	public function ajax_states() {
		
		$cid = $this->input->post('cid');
        $data = array(); $return = array();
		
		$states = $this->custom->get_where('states',array('c_id'=>$cid));
		foreach($states as $state){
			$data['id']=$state->id;
			$data['name']=$state->sname;
			
			array_push($return,$data);
		}
		echo json_encode($return);
	}


	public function ajax_shortlist() {
		
		$uid = $this->input->post('uid');
		$jobid = $this->input->post('jobid');
		$invite_date = date('Y-m-d  H:i:s');
		$sj_status = 3;

		$invite = $this->custom->get_where('stu_saved_applied_jobs',array('agency_id'=>$this->data['uid'],'sj_status'=>3));

		if(count($invite)<=$this->data['settings'][0]->s_resume_access){
			$inarr = array(
				'u_id'=>$uid,
				'agency_id'=>$this->data['uid'],
				'p_id'=>$jobid,
				'invite_date'=>$invite_date,
				'sj_status'=>$sj_status,
				'created'=>$invite_date,
				'modified'=>$invite_date,
	
			);
	
			$insert = $this->custom->insert('stu_saved_applied_jobs',$inarr); 
			if($insert){ 
				echo 1;
			}else{
				echo 0;
			}
		}else{
			echo 2;
		}


		

		
        /* $data = array(); $return = array();
		
		$states = $this->custom->get_where('states',array('c_id'=>$cid));
		foreach($states as $state){
			$data['id']=$state->id;
			$data['name']=$state->sname;
			
			array_push($return,$data);
		}
		echo json_encode($return); */
	}
	
	
	
	
	
	
	
	
	
}