var THEMEMASCOT = {};

!function(a) {
    "use strict";
    var b = a(document);
    var c = a(document.body);
    var d = a(window);
    var e = a("html");
    var f = a("body");
    var g = a("#wrapper");
    var h = a("#header");
    var i = a("#footer");
    var j = a("section");
    var k = a(".gallery-isotope");
    var l = ".portfolio-filter a";
    var m = a(".portfolio-filter a:eq(0)");
    var n = a(".portfolio-slider");
    THEMEMASCOT.isMobile = {
        Android: function() {
            return navigator.userAgent.match(/Android/i);
        },
        BlackBerry: function() {
            return navigator.userAgent.match(/BlackBerry/i);
        },
        iOS: function() {
            return navigator.userAgent.match(/iPhone|iPad|iPod/i);
        },
        Opera: function() {
            return navigator.userAgent.match(/Opera Mini/i);
        },
        Windows: function() {
            return navigator.userAgent.match(/IEMobile/i);
        },
        any: function() {
            return THEMEMASCOT.isMobile.Android() || THEMEMASCOT.isMobile.BlackBerry() || THEMEMASCOT.isMobile.iOS() || THEMEMASCOT.isMobile.Opera() || THEMEMASCOT.isMobile.Windows();
        }
    };
    THEMEMASCOT.isRTL = {
        check: function() {
            if ("rtl" == a("html").attr("dir")) return true; else return false;
        }
    };
    THEMEMASCOT.urlParameter = {
        get: function(a) {
            var b = decodeURIComponent(window.location.search.substring(1)), c = b.split("&"), d, e;
            for (e = 0; e < c.length; e++) {
                d = c[e].split("=");
                if (d[0] === a) return void 0 === d[1] ? true : d[1];
            }
        }
    };
    THEMEMASCOT.bmiCalculator = {
        magic: function(a) {
            var b = "";
            var c = "";
            if (a) {
                if (a < 15) c = "very severely underweight";
                if (a >= 15 && a < 16) c = "severely underweight";
                if (a >= 16 && a < 18.5) c = "underweight";
                if (a >= 18.5 && a < 25) c = "normal";
                if (a >= 25 && a < 30) c = "overweight";
                if (a >= 30 && a < 35) c = "moderately obese";
                if (a >= 35 && a <= 40) c = "severely obese";
                if (a > 40) c = "very severely obese";
                b = "Your BMI is <span>" + a + "</span><br />" + "You are <span>" + c + "</span>.";
            } else b = "You broke it!";
            return b;
        },
        calculateStandard: function(a) {
            var b = a.find('input[name="bmi_standard_weight_lbs"]').val();
            var c = a.find('input[name="bmi_standard_height_ft"]').val();
            var d = a.find('input[name="bmi_standard_height_in"]').val();
            var e = a.find('input[name="bmi_standard_age"]').val();
            var f = a.find('radio[name="bmi_standard_gender"]').val();
            var g = 12 * parseInt(c, 10) + parseInt(d, 10);
            var h = parseFloat(b) / (g * g) * 703;
            var i = THEMEMASCOT.bmiCalculator.magic(h);
            a.find("#bmi_standard_calculator_form_result").html(i).fadeIn("slow");
        },
        calculateMetric: function(a) {
            var b = a.find('input[name="bmi_metric_weight_kg"]').val();
            var c = a.find('input[name="bmi_metric_height_cm"]').val();
            var d = a.find('input[name="bmi_standard_age"]').val();
            var e = a.find('radio[name="bmi_standard_gender"]').val();
            var f = parseFloat(b);
            var g = .01 * parseFloat(c);
            var h = f / (g * g);
            var i = THEMEMASCOT.bmiCalculator.magic(h);
            a.find("#bmi_metric_calculator_form_result").html(i).fadeIn("slow");
        },
        init: function() {
            var b = a("#form_bmi_standard_calculator");
            b.on("submit", function(a) {
                a.preventDefault();
                THEMEMASCOT.bmiCalculator.calculateStandard(b);
                return false;
            });
            var c = a("#form_bmi_metric_calculator");
            c.on("submit", function(a) {
                a.preventDefault();
                THEMEMASCOT.bmiCalculator.calculateMetric(c);
                return false;
            });
        }
    };
    THEMEMASCOT.initialize = {
        init: function() {
            THEMEMASCOT.bmiCalculator.init();
            THEMEMASCOT.initialize.TM_datePicker();
            THEMEMASCOT.initialize.TM_ddslick();
            THEMEMASCOT.initialize.TM_loadBSParentModal();
            THEMEMASCOT.initialize.TM_platformDetect();
            THEMEMASCOT.initialize.TM_onLoadModal();
            THEMEMASCOT.initialize.TM_customDataAttributes();
            THEMEMASCOT.initialize.TM_parallaxBgInit();
            THEMEMASCOT.initialize.TM_resizeFullscreen();
            THEMEMASCOT.initialize.TM_prettyPhoto_lightbox();
            THEMEMASCOT.initialize.TM_nivolightbox();
            THEMEMASCOT.initialize.TM_fitVids();
            THEMEMASCOT.initialize.TM_YTPlayer();
            THEMEMASCOT.initialize.TM_equalHeightDivs();
        },
        TM_datePicker: function() {
            a(".date-picker").datepicker();
            a(".time-picker").timepicker();
            a(".datetime-picker").datetimepicker();
        },
        TM_ddslick: function() {
            a("select.ddslick").each(function() {
                var b = a(this).attr("name");
                var c = a(this).attr("id");
                a("#" + c).ddslick({
                    imagePosition: "left",
                    onSelected: function(d) {
                        a("#" + c + " .dd-selected-value").prop("name", b);
                    }
                });
            });
        },
        TM_sliderRange: function() {
            a(".slider-range").each(function() {
                var b = a(this).attr("id");
                var c = a(this).data("target");
                a("#" + c).slider({
                    range: "max",
                    min: 2001,
                    max: 2016,
                    value: 2010,
                    slide: function(c, d) {
                        a("#" + b).val(d.value);
                    }
                });
                a("#" + b).val(a("#" + c).slider("value"));
            });
        },
        TM_loadBSParentModal: function() {
            var b = true;
            if (b) a.ajax({
                url: "ajax-load/bootstrap-parent-modal.html",
                success: function(a) {
                    f.append(a);
                },
                dataType: "html"
            });
        },
        TM_preLoaderClickDisable: function() {
            var b = a("#preloader");
            b.children("#disable-preloader").on("click", function(a) {
                b.fadeOut();
                return false;
            });
        },
        TM_preLoaderOnLoad: function() {
            var b = a("#preloader");
            b.delay(200).fadeOut("slow");
        },
        TM_platformDetect: function() {
            if (THEMEMASCOT.isMobile.any()) e.addClass("mobile"); else e.addClass("no-mobile");
        },
        TM_onLoadModal: function() {
            var b = a(".on-pageload-popup-modal");
            if (b.length > 0) b.each(function() {
                var b = a(this);
                var c = b.data("target");
                var d = b.data("timeout");
                var e = b.data("delay");
                e = !e ? 2500 : Number(e) + 2500;
                if (!b.hasClass("cookie-enabled")) a.removeCookie(c);
                var f = setTimeout(function() {
                    a.magnificPopup.open({
                        items: {
                            src: c
                        },
                        type: "inline",
                        mainClass: "mfp-no-margins mfp-fade",
                        closeBtnInside: false,
                        fixedContentPos: true,
                        removalDelay: 500,
                        callbacks: {
                            afterClose: function() {
                                if (element.hasClass("cookie-enabled")) a.cookie(c, "0");
                            }
                        }
                    }, 0);
                }, Number(e));
                if ("" !== d) var g = setTimeout(function() {
                    a.magnificPopup.close();
                }, Number(e) + Number(d));
            });
        },
        TM_onLoadModal2: function() {
            var b = a(".modal-on-load");
            if (b.length > 0) b.each(function() {
                var b = a(this), c = b.attr("data-target"), d = c.split("#")[1], e = b.attr("data-delay"), f = b.attr("data-timeout"), g = b.attr("data-animate-in"), h = b.attr("data-animate-out");
                if (!b.hasClass("enable-cookie")) a.removeCookie(d);
                if (b.hasClass("enable-cookie")) {
                    var i = a.cookie(d);
                    if ("undefined" !== typeof i && "0" == i) return true;
                }
                if (!e) e = 1500; else e = Number(e) + 1500;
                var j = setTimeout(function() {
                    a.magnificPopup.open({
                        items: {
                            src: c
                        },
                        type: "inline",
                        mainClass: "mfp-no-margins mfp-fade",
                        closeBtnInside: false,
                        fixedContentPos: true,
                        removalDelay: 500,
                        callbacks: {
                            open: function() {
                                if ("" !== g) a(c).addClass(g + " animated");
                            },
                            beforeClose: function() {
                                if ("" !== h) a(c).removeClass(g).addClass(h);
                            },
                            afterClose: function() {
                                if ("" !== g || "" !== h) a(c).removeClass(g + " " + h + " animated");
                                if (b.hasClass("enable-cookie")) a.cookie(d, "0");
                            }
                        }
                    }, 0);
                }, Number(e));
                if ("" !== f) var k = setTimeout(function() {
                    a.magnificPopup.close();
                }, Number(e) + Number(f));
            });
        },
        TM_hashForwarding: function() {
            if (window.location.hash) {
                var b = a(window.location.hash).offset().top;
                a("html, body").animate({
                    scrollTop: b
                });
            }
        },
        TM_customDataAttributes: function() {
            a("[data-bg-color]").each(function() {
                a(this).css("cssText", "background: " + a(this).data("bg-color") + " !important;");
            });
            a("[data-bg-img]").each(function() {
                a(this).css("background-image", "url(" + a(this).data("bg-img") + ")");
            });
            a("[data-text-color]").each(function() {
                a(this).css("color", a(this).data("text-color"));
            });
            a("[data-font-size]").each(function() {
                a(this).css("font-size", a(this).data("font-size"));
            });
            a("[data-height]").each(function() {
                a(this).css("height", a(this).data("height"));
            });
            a("[data-border]").each(function() {
                a(this).css("border", a(this).data("border"));
            });
            a("[data-margin-top]").each(function() {
                a(this).css("margin-top", a(this).data("margin-top"));
            });
            a("[data-margin-right]").each(function() {
                a(this).css("margin-right", a(this).data("margin-right"));
            });
            a("[data-margin-bottom]").each(function() {
                a(this).css("margin-bottom", a(this).data("margin-bottom"));
            });
            a("[data-margin-left]").each(function() {
                a(this).css("margin-left", a(this).data("margin-left"));
            });
        },
        TM_parallaxBgInit: function() {
            if (!THEMEMASCOT.isMobile.any() && d.width() >= 800) a(".parallax").each(function() {
                var b = void 0 === a(this).data("parallax-ratio") ? "0.5" : a(this).data("parallax-ratio");
                a(this).parallax("50%", b);
            }); else a(".parallax").addClass("mobile-parallax");
        },
        TM_resizeFullscreen: function() {
            var b = d.height();
            a(".fullscreen, .revslider-fullscreen").height(b);
        },
        TM_magnificPopup_lightbox: function() {
            a(".image-popup-lightbox").magnificPopup({
                type: "image",
                closeOnContentClick: true,
                closeBtnInside: false,
                fixedContentPos: true,
                mainClass: "mfp-no-margins mfp-fade",
                image: {
                    verticalFit: true
                }
            });
            a(".image-popup-vertical-fit").magnificPopup({
                type: "image",
                closeOnContentClick: true,
                mainClass: "mfp-img-mobile",
                image: {
                    verticalFit: true
                }
            });
            a(".image-popup-fit-width").magnificPopup({
                type: "image",
                closeOnContentClick: true,
                image: {
                    verticalFit: false
                }
            });
            a(".image-popup-no-margins").magnificPopup({
                type: "image",
                closeOnContentClick: true,
                closeBtnInside: false,
                fixedContentPos: true,
                mainClass: "mfp-no-margins mfp-with-zoom",
                image: {
                    verticalFit: true
                },
                zoom: {
                    enabled: true,
                    duration: 300
                }
            });
            a(".popup-gallery").magnificPopup({
                delegate: "a",
                type: "image",
                tLoading: "Loading image #%curr%...",
                mainClass: "mfp-img-mobile",
                gallery: {
                    enabled: true,
                    navigateByImgClick: true,
                    preload: [ 0, 1 ]
                },
                image: {
                    tError: '<a href="%url%">The image #%curr%</a> could not be loaded.',
                    titleSrc: function(a) {
                        return a.el.attr("title") + "<small>by Marsel Van Oosten</small>";
                    }
                }
            });
            a(".zoom-gallery").magnificPopup({
                delegate: "a",
                type: "image",
                closeOnContentClick: false,
                closeBtnInside: false,
                mainClass: "mfp-with-zoom mfp-img-mobile",
                image: {
                    verticalFit: true,
                    titleSrc: function(a) {
                        return a.el.attr("title") + ' &middot; <a class="image-source-link" href="' + a.el.attr("data-source") + '" target="_blank">image source</a>';
                    }
                },
                gallery: {
                    enabled: true
                },
                zoom: {
                    enabled: true,
                    duration: 300,
                    opener: function(a) {
                        return a.find("img");
                    }
                }
            });
            a(".popup-youtube, .popup-vimeo, .popup-gmaps").magnificPopup({
                disableOn: 700,
                type: "iframe",
                mainClass: "mfp-fade",
                removalDelay: 160,
                preloader: false,
                fixedContentPos: false
            });
            a(".popup-with-zoom-anim").magnificPopup({
                type: "inline",
                fixedContentPos: false,
                fixedBgPos: true,
                overflowY: "auto",
                closeBtnInside: true,
                preloader: false,
                midClick: true,
                removalDelay: 300,
                mainClass: "my-mfp-zoom-in"
            });
            a(".popup-with-move-anim").magnificPopup({
                type: "inline",
                fixedContentPos: false,
                fixedBgPos: true,
                overflowY: "auto",
                closeBtnInside: true,
                preloader: false,
                midClick: true,
                removalDelay: 300,
                mainClass: "my-mfp-slide-bottom"
            });
            a(".ajaxload-popup").magnificPopup({
                type: "ajax",
                alignTop: true,
                overflowY: "scroll",
                callbacks: {
                    parseAjax: function(a) {
                        THEMEMASCOT.initialize.TM_datePicker();
                    }
                }
            });
            a(".form-ajax-load").magnificPopup({
                type: "ajax"
            });
            a(".popup-with-form").magnificPopup({
                type: "inline",
                preloader: false,
                focus: "#name",
                mainClass: "mfp-no-margins mfp-fade",
                closeBtnInside: false,
                fixedContentPos: true,
                callbacks: {
                    beforeOpen: function() {
                        if (d.width() < 700) this.st.focus = false; else this.st.focus = "#name";
                    }
                }
            });
            var b = a('[data-lightbox="ajax"]');
            if (b.length > 0) b.magnificPopup({
                type: "ajax",
                closeBtnInside: false,
                callbacks: {
                    ajaxContentAdded: function(a) {},
                    open: function() {},
                    close: function() {}
                }
            });
            var c = a('[data-lightbox="image"]');
            if (c.length > 0) c.magnificPopup({
                type: "image",
                closeOnContentClick: true,
                closeBtnInside: false,
                fixedContentPos: true,
                mainClass: "mfp-no-margins mfp-with-zoom",
                image: {
                    verticalFit: true
                }
            });
            var e = a('[data-lightbox="gallery"]');
            if (e.length > 0) e.each(function() {
                var b = a(this);
                b.magnificPopup({
                    delegate: 'a[data-lightbox="gallery-item"]',
                    type: "image",
                    closeOnContentClick: true,
                    closeBtnInside: false,
                    fixedContentPos: true,
                    mainClass: "mfp-no-margins mfp-with-zoom",
                    image: {
                        verticalFit: true
                    },
                    gallery: {
                        enabled: true,
                        navigateByImgClick: true,
                        preload: [ 0, 1 ]
                    },
                    zoom: {
                        enabled: true,
                        duration: 300,
                        opener: function(a) {
                            return a.find("img");
                        }
                    }
                });
            });
            var f = a('[data-lightbox="iframe"]');
            if (f.length > 0) f.magnificPopup({
                disableOn: 600,
                type: "iframe",
                removalDelay: 160,
                preloader: false,
                fixedContentPos: false
            });
            var g = a('[data-lightbox="inline"]');
            if (g.length > 0) g.magnificPopup({
                type: "inline",
                mainClass: "mfp-no-margins mfp-zoom-in",
                closeBtnInside: false,
                fixedContentPos: true
            });
        },
        TM_prettyPhoto_lightbox: function() {
            a("a[data-rel^='prettyPhoto']").prettyPhoto({
                hook: "data-rel",
                animation_speed: "normal",
                theme: "light_square",
                slideshow: 3e3,
                autoplay_slideshow: false,
                social_tools: false
            });
        },
        TM_nivolightbox: function() {
            a("a[data-lightbox-gallery]").nivoLightbox({
                effect: "fadeScale",
                afterShowLightbox: function() {
                    var b = a(".nivo-lightbox-content > iframe");
                    if (b.length > 0) {
                        var c = b.attr("src");
                        b.attr("src", c + "?autoplay=1");
                    }
                }
            });
        },
        TM_wow: function() {
            var a = new WOW({
                mobile: false
            });
            a.init();
        },
        TM_fitVids: function() {
            f.fitVids();
        },
        TM_YTPlayer: function() {
            a(".player").mb_YTPlayer();
        },
        TM_equalHeightDivs: function() {
            var b = a(".equal-height");
            b.children("div").css("min-height", "auto");
            b.equalHeights();
            var c = a(".equal-height-inner");
            c.children("div").css("min-height", "auto");
            c.children("div").children("div").css("min-height", "auto");
            c.equalHeights();
            c.children("div").each(function() {
                a(this).children("div").css("min-height", a(this).css("min-height"));
            });
            var d = a(".equal-height-pricing-table");
            d.children("div").css("min-height", "auto");
            d.children("div").children("div").css("min-height", "auto");
            d.equalHeights();
            d.children("div").each(function() {
                a(this).children("div").css("min-height", a(this).css("min-height"));
            });
        }
    };
    THEMEMASCOT.header = {
        init: function() {
            var a = setTimeout(function() {
                THEMEMASCOT.header.TM_fullscreenMenu();
                THEMEMASCOT.header.TM_sidePanelReveal();
                THEMEMASCOT.header.TM_scroolToTopOnClick();
                THEMEMASCOT.header.TM_scrollToFixed();
                THEMEMASCOT.header.TM_topnavAnimate();
                THEMEMASCOT.header.TM_scrolltoTarget();
                THEMEMASCOT.header.TM_menuzord();
                THEMEMASCOT.header.TM_navLocalScorll();
                THEMEMASCOT.header.TM_menuCollapseOnClick();
                THEMEMASCOT.header.TM_homeParallaxFadeEffect();
                THEMEMASCOT.header.TM_topsearch_toggle();
            }, 0);
        },
        TM_fullscreenMenu: function() {
            var b = a(".menu-full-page .fullpage-nav-toggle");
            b.menufullpage();
        },
        TM_sidePanelReveal: function() {
            a(".side-panel-trigger").on("click", function(a) {
                f.toggleClass("side-panel-open");
                if (THEMEMASCOT.isMobile.any()) f.toggleClass("overflow-hidden");
                return false;
            });
            a(".has-side-panel .body-overlay").on("click", function(a) {
                f.toggleClass("side-panel-open");
                return false;
            });
            a(".side-panel-nav .nav .tree-toggler").on("click", function(b) {
                a(this).parent().children("ul.tree").toggle(300);
            });
        },
        TM_scroolToTop: function() {
            if (d.scrollTop() > 600) a(".scrollToTop").fadeIn(); else a(".scrollToTop").fadeOut();
        },
        TM_scroolToTopOnClick: function() {
            c.on("click", ".scrollToTop", function(b) {
                a("html, body").animate({
                    scrollTop: 0
                }, 800);
                return false;
            });
        },
        TM_menuCollapseOnClick: function() {
            b.on("click", ".onepage-nav a", function(b) {
                a(".showhide").trigger("click");
                return false;
            });
        },
        TM_activateMenuItemOnReach: function() {
            var b = a(".onepage-nav");
            var c = d.scrollTop() + 2;
            var e = b.outerHeight();
            j.each(function() {
                var d = a(this).offset().top - e - 80, f = d + a(this).outerHeight();
                if (c >= d && c <= f) {
                    b.find("a").parent().removeClass("current").removeClass("active");
                    j.removeClass("current").removeClass("active");
                    b.find('a[href="#' + a(this).attr("id") + '"]').parent().addClass("current").addClass("active");
                }
            });
        },
        TM_scrolltoTarget: function() {
            a(".smooth-scroll-to-target, .fullscreen-onepage-nav a").on("click", function(b) {
                b.preventDefault();
                var c = a(this);
                var d = a(".header .header-nav");
                var e = 0;
                if (d[0]) e = d.outerHeight(true); else e = 0;
                if (f.hasClass("vertical-nav")) e = 0;
                var g = a(c.attr("href")).offset().top - e;
                a("html, body").stop().animate({
                    scrollTop: g
                }, 1500, "easeInOutExpo");
            });
        },
        TM_navLocalScorll: function() {
            var b = -60;
            a("#menuzord .menuzord-menu, #menuzord-right .menuzord-menu").localScroll({
                target: "body",
                duration: 800,
                offset: b,
                easing: "easeInOutExpo"
            });
            a("#menuzord-side-panel .menuzord-menu, #menuzord-verticalnav .menuzord-menu, #fullpage-nav").localScroll({
                target: "body",
                duration: 800,
                offset: 0,
                easing: "easeInOutExpo"
            });
        },
        TM_scrollToFixed: function() {
            a(".navbar-scrolltofixed").scrollToFixed();
            a(".scrolltofixed").scrollToFixed({
                marginTop: a(".header .header-nav").outerHeight(true) + 10,
                limit: function() {
                    var b = a("#footer").offset().top - a(this).outerHeight(true);
                    return b;
                }
            });
            a("#sidebar").scrollToFixed({
                marginTop: a(".header .header-nav").outerHeight() + 20,
                limit: function() {
                    var b = a("#footer").offset().top - a("#sidebar").outerHeight() - 20;
                    return b;
                }
            });
        },
        TM_menuzord: function() {
            a("#menuzord").menuzord({
                align: "left",
                effect: "slide",
                animation: "none",
                indicatorFirstLevel: "<i class='fa fa-angle-down'></i>",
                indicatorSecondLevel: "<i class='fa fa-angle-right'></i>"
            });
            a("#menuzord-right").menuzord({
                align: "right",
                effect: "slide",
                animation: "none",
                indicatorFirstLevel: "<i class='fa fa-angle-down'></i>",
                indicatorSecondLevel: "<i class='fa fa-angle-right'></i>"
            });
            a("#menuzord-side-panel").menuzord({
                align: "right",
                effect: "slide",
                animation: "none",
                indicatorFirstLevel: "",
                indicatorSecondLevel: "<i class='fa fa-angle-right'></i>"
            });
            a("#menuzord-verticalnav").menuzord({
                align: "right",
                effect: "slide",
                animation: "none",
                indicatorFirstLevel: "<i class='fa fa-angle-down'></i>",
                indicatorSecondLevel: "<i class='fa fa-angle-right'></i>"
            });
        },
        TM_topnavAnimate: function() {
            if (d.scrollTop() > 50) a(".navbar-sticky-animated").removeClass("animated-active"); else a(".navbar-sticky-animated").addClass("animated-active");
            if (d.scrollTop() > 50) a(".navbar-sticky-animated .header-nav-wrapper .container, .navbar-sticky-animated .header-nav-wrapper .container-fluid").removeClass("add-padding"); else a(".navbar-sticky-animated .header-nav-wrapper .container, .navbar-sticky-animated .header-nav-wrapper .container-fluid").addClass("add-padding");
        },
        TM_homeParallaxFadeEffect: function() {
            if (d.width() >= 1200) {
                var b = d.scrollTop();
                a(".content-fade-effect .home-content .home-text").css("padding-top", .061 * b + "%").css("opacity", 1 - .0012 * b);
            }
        },
        TM_topsearch_toggle: function() {
            c.on("click", "#top-search-toggle", function(b) {
                b.preventDefault();
                a(".search-form-wrapper.toggle").toggleClass("active");
                return false;
            });
        }
    };
    THEMEMASCOT.widget = {
        init: function() {
            var a = setTimeout(function() {
                THEMEMASCOT.widget.TM_shopClickEvents();
                THEMEMASCOT.widget.TM_fcCalender();
                THEMEMASCOT.widget.TM_verticalTimeline();
                THEMEMASCOT.widget.TM_verticalMasonryTimeline();
                THEMEMASCOT.widget.TM_masonryIsotop();
                THEMEMASCOT.widget.TM_pieChart();
                THEMEMASCOT.widget.TM_progressBar();
                THEMEMASCOT.widget.TM_funfact();
                THEMEMASCOT.widget.TM_instagramFeed();
                THEMEMASCOT.widget.TM_jflickrfeed();
                THEMEMASCOT.widget.TM_accordion_toggles();
                THEMEMASCOT.widget.TM_tooltip();
            }, 0);
        },
        TM_shopClickEvents: function() {
            c.on("click", ".quantity .plus", function(b) {
                var c = parseInt(a(this).parent().children(".qty").val(), 10);
                if (!isNaN(c)) a(this).parent().children(".qty").val(c + 1);
                return false;
            });
            c.on("click", ".quantity .minus", function(b) {
                var c = parseInt(a(this).parent().children(".qty").val(), 10);
                if (!isNaN(c) && c > 0) a(this).parent().children(".qty").val(c - 1);
                return false;
            });
            c.on("click", "#checkbox-ship-to-different-address", function(b) {
                a("#checkout-shipping-address").toggle(this.checked);
            });
        },
        TM_fcCalender: function() {
            if ("undefined" !== typeof calendarEvents) a("#full-event-calendar").fullCalendar({
                header: {
                    left: "prev,next today",
                    center: "title",
                    right: "month,agendaWeek,agendaDay"
                },
                defaultDate: "2016-01-12",
                selectable: true,
                selectHelper: true,
                select: function(b, c) {
                    var d = prompt("Event Title:");
                    var e;
                    if (d) {
                        e = {
                            title: d,
                            start: b,
                            end: c
                        };
                        a("#calendar").fullCalendar("renderEvent", e, true);
                    }
                    a("#calendar").fullCalendar("unselect");
                },
                editable: true,
                eventLimit: true,
                events: calendarEvents
            });
        },
        TM_verticalTimeline: function() {
            var b = a(".cd-timeline-block"), c = .8;
            e(b, c);
            d.on("scroll", function() {
                !window.requestAnimationFrame ? setTimeout(function() {
                    f(b, c);
                }, 100) : window.requestAnimationFrame(function() {
                    f(b, c);
                });
            });
            function e(b, c) {
                b.each(function() {
                    a(this).offset().top > d.scrollTop() + d.height() * c && a(this).find(".cd-timeline-img, .cd-timeline-content").addClass("is-hidden");
                });
            }
            function f(b, c) {
                b.each(function() {
                    a(this).offset().top <= d.scrollTop() + d.height() * c && a(this).find(".cd-timeline-img").hasClass("is-hidden") && a(this).find(".cd-timeline-img, .cd-timeline-content").removeClass("is-hidden").addClass("bounce-in");
                });
            }
        },
        TM_verticalMasonryTimeline: function() {
            var b = a(".vertical-masonry-timeline");
            b.isotope({
                itemSelector: ".each-masonry-item",
                sortBy: "original-order",
                layoutMode: "masonry",
                resizable: false
            });
            function c() {
                b.children(".each-masonry-item").each(function(b, c) {
                    var d = a(this);
                    var e = a(this).prev();
                    var f = parseInt(d.css("top"), 10);
                    var g = parseInt(e.css("top"), 10);
                    var h = f - g;
                    var i = 0;
                    if (h) if (h <= 87) {
                        i = 87 - h;
                        d.find(".timeline-post-format").animate({
                            top: i
                        }, 300);
                    }
                    if (0 === a(this).position().left) {
                        a(this).removeClass("item-right");
                        a(this).addClass("item-left");
                    } else {
                        a(this).removeClass("item-left");
                        a(this).addClass("item-right");
                    }
                });
            }
            c();
            d.resize(function() {
                c();
            });
        },
        TM_masonryIsotop: function() {
            var b;
            if (k.hasClass("masonry")) b = "masonry"; else b = "fitRows";
            k.imagesLoaded(function() {
                k.isotope({
                    itemSelector: ".gallery-item",
                    layoutMode: b,
                    filter: "*"
                });
            });
            c.on("click", l, function(c) {
                a(l).removeClass("active");
                a(this).addClass("active");
                var d = a(this).data("filter");
                k.isotope({
                    itemSelector: ".gallery-item",
                    layoutMode: b,
                    filter: d
                });
                return false;
            });
            THEMEMASCOT.slider.TM_flexslider();
        },
        TM_portfolioFlexSliderGalleryPopUpInit: function() {
            var b = k.find(".slides");
            b.each(function() {
                var b = a(this).find("li > a");
                var c = [];
                for (var d = 0; d < b.length; d++) c.push({
                    src: a(b[d]).attr("href"),
                    title: a(b[d]).attr("title")
                });
                a(this).parent().parent().parent().find(".icons-holder").magnificPopup({
                    items: c,
                    type: "image",
                    gallery: {
                        enabled: true
                    }
                });
            });
        },
        TM_isotopeGridRearrange: function() {
            var a;
            if (k.hasClass("masonry")) a = "masonry"; else a = "fitRows";
            k.isotope({
                itemSelector: ".gallery-item",
                layoutMode: a
            });
        },
        TM_isotopeGridShuffle: function() {
            k.isotope("shuffle");
        },
        TM_countDownTimer: function() {
            var b = a("#clock-count-down");
            var c = b.data("endingdate");
            b.countdown(c, function(b) {
                var c = "" + '<ul class="countdown-timer">' + "<li>%D <span>Days</span></li>" + "<li>%H <span>Hours</span></li>" + "<li>%M <span>Minutes</span></li>" + "<li>%S <span>Seconds</span></li>" + "</ul>";
                a(this).html(b.strftime(c));
            });
        },
        TM_pieChart: function() {
            var b = a(".piechart");
            b.appear();
            c.on("appear", ".piechart", function() {
                var b = a(this);
                if (!b.hasClass("appeared")) {
                    var c = b.data("barcolor");
                    var d = b.data("trackcolor");
                    var e = b.data("linewidth");
                    var f = b.data("boxwidth");
                    b.css("width", f);
                    b.easyPieChart({
                        animate: 3e3,
                        barColor: c,
                        trackColor: d,
                        easing: "easeOutBounce",
                        lineWidth: e,
                        size: f,
                        lineCap: "square",
                        scaleColor: false,
                        onStep: function(b, c, d) {
                            a(this.el).find("span").text(Math.round(d));
                        }
                    });
                    b.addClass("appeared");
                }
            });
        },
        TM_progressBar: function() {
            var b = a(".progress-bar");
            b.appear();
            c.on("appear", ".progress-bar", function() {
                var b = a(this);
                if (!b.hasClass("appeared")) {
                    var c = b.data("percent");
                    var d = b.data("barcolor");
                    b.append('<span class="percent">' + c + "%" + "</span>").css("background-color", d).css("width", c + "%").addClass("appeared");
                }
            });
        },
        TM_funfact: function() {
            var b = a(".animate-number");
            b.appear();
            c.on("appear", ".animate-number", function() {
                b.each(function() {
                    var b = a(this);
                    if (!b.hasClass("appeared")) b.animateNumbers(b.attr("data-value"), true, parseInt(b.attr("data-animation-duration"), 10)).addClass("appeared");
                });
            });
        },
        TM_instagramFeed: function() {
            a(".instagram-feed").each(function() {
                var b = a(this);
                var c = new Instafeed({
                    target: b.attr("id"),
                    get: "user",
                    userId: b.data("userid"),
                    accessToken: b.data("accesstoken"),
                    resolution: b.data("resolution"),
                    limit: b.data("limit"),
                    template: '<div class="item"><figure><img src="{{image}}" /><a href="{{link}}" class="link-out" target="_blank"><i class="fa fa-link"></i></a></figure></div>',
                    after: function() {}
                });
                c.run();
            });
            a(".instagram-feed-carousel").each(function() {
                var b = a(this);
                var c = new Instafeed({
                    target: b.attr("id"),
                    get: "user",
                    userId: b.data("userid"),
                    accessToken: b.data("accesstoken"),
                    resolution: b.data("resolution"),
                    limit: b.data("limit"),
                    template: '<div class="item"><figure><img src="{{image}}" /><a href="{{link}}" class="link-out" target="_blank"><i class="fa fa-link"></i></a></figure></div>',
                    after: function() {
                        b.owlCarousel({
                            rtl: THEMEMASCOT.isRTL.check(),
                            autoplay: true,
                            autoplayTimeout: 4e3,
                            loop: true,
                            margin: 15,
                            dots: true,
                            nav: false,
                            responsive: {
                                0: {
                                    items: 2
                                },
                                768: {
                                    items: 4
                                },
                                1e3: {
                                    items: 5
                                }
                            }
                        });
                    }
                });
                c.run();
            });
        },
        TM_jflickrfeed: function() {
            a(".flickr-widget .flickr-feed, .jflickrfeed").each(function() {
                var b = a(this);
                b.jflickrfeed({
                    limit: 9,
                    qstrings: {
                        id: b.data("userid")
                    },
                    itemTemplate: '<a href="{{link}}" title="{{title}}" target="_blank"><img src="{{image_m}}" alt="{{title}}">  </a>'
                });
            });
        },
        TM_accordion_toggles: function() {
            var b = a(".panel-group .collapse");
            b.on("show.bs.collapse", function(b) {
                a(this).closest(".panel-group").find("[href='#" + a(this).attr("id") + "']").addClass("active");
            });
            b.on("hide.bs.collapse", function(b) {
                a(this).closest(".panel-group").find("[href='#" + a(this).attr("id") + "']").removeClass("active");
            });
        },
        TM_tooltip: function() {
            a('[data-toggle="tooltip"]').tooltip();
        },
        TM_twittie: function() {
            var b = a(".twitter-feed");
            var c = a(".twitter-feed-carousel");
            if (b.length > 0) b.twittie({
                username: b.data("username"),
                dateFormat: "%b. %d, %Y",
                template: '{{tweet}} <div class="date">{{date}}</div>',
                count: void 0 === b.data("count") ? 4 : b.data("count"),
                loadingText: "Loading!"
            });
            if (c.length > 0) c.twittie({
                username: c.data("username"),
                dateFormat: "%b. %d, %Y",
                template: '{{tweet}} <div class="date">{{date}}</div>',
                count: void 0 === c.data("count") ? 4 : c.data("count"),
                loadingText: "Loading!"
            }, function() {
                c.find("ul").owlCarousel({
                    rtl: THEMEMASCOT.isRTL.check(),
                    autoplay: true,
                    autoplayTimeout: 2e3,
                    loop: true,
                    items: 1,
                    dots: true,
                    nav: false
                });
            });
        }
    };
    THEMEMASCOT.slider = {
        init: function() {
            var a = setTimeout(function() {
                THEMEMASCOT.slider.TM_typedAnimation();
                THEMEMASCOT.slider.TM_flexslider();
                THEMEMASCOT.slider.TM_owlCarousel();
                THEMEMASCOT.slider.TM_maximageSlider();
                THEMEMASCOT.slider.TM_bxslider();
            }, 0);
        },
        TM_typedAnimation: function() {
            if (a(".typed-text-carousel").length) a(".typed-text-carousel").each(function() {
                var b = a(this).find("span:first-child").text();
                var c = a(this).find("span:nth-child(2)").text();
                var d = a(this).find("span:nth-child(3)").text();
                var e = "";
                var f = a(this);
                if (!c.trim() || !d.trim()) e = [ b ];
                if (!d.trim() && c.length) e = [ b, c ];
                if (b.length && c.length && d.length) e = [ b, c, d ];
                var g = a(this).data("speed");
                var h = a(this).data("back_delay");
                var i = a(this).data("loop");
                a(this).typed({
                    strings: e,
                    typeSpeed: g,
                    backSpeed: 0,
                    backDelay: h,
                    cursorChar: "|",
                    loop: i,
                    contentType: "text",
                    loopCount: false
                });
            });
        },
        TM_flexslider: function() {
            var b = a(".flexslider-wrapper").find(".flexslider");
            THEMEMASCOT.widget.TM_portfolioFlexSliderGalleryPopUpInit();
            b.each(function() {
                var b = a(this);
                var c = void 0 === b.parent().data("direction") ? "horizontal" : b.parent().data("direction");
                var d = void 0 === b.parent().data("controlnav") ? true : b.parent().data("controlnav");
                var e = void 0 === b.parent().data("directionnav") ? true : b.parent().data("directionnav");
                b.flexslider({
                    rtl: THEMEMASCOT.isRTL.check(),
                    selector: ".slides > li",
                    animation: "slide",
                    easing: "swing",
                    direction: c,
                    slideshow: true,
                    slideshowSpeed: 7e3,
                    animationSpeed: 600,
                    pauseOnHover: false,
                    controlNav: d,
                    directionNav: e,
                    start: function(a) {
                        imagesLoaded(k, function() {
                            setTimeout(function() {
                                m.trigger("click");
                            }, 500);
                        });
                        THEMEMASCOT.initialize.TM_magnificPopup_lightbox();
                        THEMEMASCOT.initialize.TM_prettyPhoto_lightbox();
                        THEMEMASCOT.initialize.TM_nivolightbox();
                    },
                    after: function() {}
                });
            });
        },
        TM_owlCarousel: function() {
            a(".owl-carousel-1col, .text-carousel, .image-carousel, .fullwidth-carousel").each(function() {
                var b = void 0 === a(this).data("dots") ? false : a(this).data("dots");
                var c = void 0 === a(this).data("nav") ? false : a(this).data("nav");
                var d = void 0 === a(this).data("duration") ? 4e3 : a(this).data("duration");
                a(this).owlCarousel({
                    rtl: THEMEMASCOT.isRTL.check(),
                    autoplay: true,
                    autoplayTimeout: d,
                    loop: true,
                    items: 1,
                    dots: b,
                    nav: c,
                    navText: [ '<i class="pe-7s-angle-left"></i>', '<i class="pe-7s-angle-right"></i>' ]
                });
            });
            a(".owl-carousel-2col").each(function() {
                var b = void 0 === a(this).data("dots") ? false : a(this).data("dots");
                var c = void 0 === a(this).data("nav") ? false : a(this).data("nav");
                var d = void 0 === a(this).data("duration") ? 4e3 : a(this).data("duration");
                a(this).owlCarousel({
                    rtl: THEMEMASCOT.isRTL.check(),
                    autoplay: true,
                    autoplayTimeout: d,
                    loop: true,
                    items: 2,
                    margin: 15,
                    dots: b,
                    nav: c,
                    navText: [ '<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>' ],
                    responsive: {
                        0: {
                            items: 1,
                            center: false
                        },
                        480: {
                            items: 1,
                            center: false
                        },
                        600: {
                            items: 1,
                            center: false
                        },
                        750: {
                            items: 2,
                            center: false
                        },
                        960: {
                            items: 2
                        },
                        1170: {
                            items: 2
                        },
                        1300: {
                            items: 2
                        }
                    }
                });
            });
            a(".owl-carousel-3col").each(function() {
                var b = void 0 === a(this).data("dots") ? false : a(this).data("dots");
                var c = void 0 === a(this).data("nav") ? false : a(this).data("nav");
                var d = void 0 === a(this).data("duration") ? 4e3 : a(this).data("duration");
                a(this).owlCarousel({
                    rtl: THEMEMASCOT.isRTL.check(),
                    autoplay: true,
                    autoplayTimeout: d,
                    loop: true,
                    items: 3,
                    margin: 15,
                    dots: b,
                    nav: c,
                    navText: [ '<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>' ],
                    responsive: {
                        0: {
                            items: 1,
                            center: false
                        },
                        480: {
                            items: 1,
                            center: false
                        },
                        600: {
                            items: 1,
                            center: false
                        },
                        750: {
                            items: 2,
                            center: false
                        },
                        960: {
                            items: 2
                        },
                        1170: {
                            items: 3
                        },
                        1300: {
                            items: 3
                        }
                    }
                });
            });
            a(".owl-carousel-4col").each(function() {
                var b = void 0 === a(this).data("dots") ? false : a(this).data("dots");
                var c = void 0 === a(this).data("nav") ? false : a(this).data("nav");
                var d = void 0 === a(this).data("duration") ? 4e3 : a(this).data("duration");
                a(this).owlCarousel({
                    rtl: THEMEMASCOT.isRTL.check(),
                    autoplay: true,
                    autoplayTimeout: d,
                    loop: true,
                    items: 4,
                    margin: 15,
                    dots: b,
                    nav: c,
                    navText: [ '<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>' ],
                    responsive: {
                        0: {
                            items: 1,
                            center: true
                        },
                        480: {
                            items: 1,
                            center: false
                        },
                        600: {
                            items: 3,
                            center: false
                        },
                        750: {
                            items: 3,
                            center: false
                        },
                        960: {
                            items: 3
                        },
                        1170: {
                            items: 4
                        },
                        1300: {
                            items: 4
                        }
                    }
                });
            });
            a(".owl-carousel-5col").each(function() {
                var b = void 0 === a(this).data("dots") ? false : a(this).data("dots");
                var c = void 0 === a(this).data("nav") ? false : a(this).data("nav");
                var d = void 0 === a(this).data("duration") ? 4e3 : a(this).data("duration");
                a(this).owlCarousel({
                    rtl: THEMEMASCOT.isRTL.check(),
                    autoplay: true,
                    autoplayTimeout: d,
                    loop: true,
                    items: 5,
                    margin: 15,
                    dots: b,
                    nav: c,
                    navText: [ '<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>' ],
                    responsive: {
                        0: {
                            items: 1,
                            center: false
                        },
                        480: {
                            items: 1,
                            center: false
                        },
                        600: {
                            items: 2,
                            center: false
                        },
                        750: {
                            items: 3,
                            center: false
                        },
                        960: {
                            items: 4
                        },
                        1170: {
                            items: 5
                        },
                        1300: {
                            items: 5
                        }
                    }
                });
            });
            a(".owl-carousel-6col").each(function() {
                var b = void 0 === a(this).data("dots") ? false : a(this).data("dots");
                var c = void 0 === a(this).data("nav") ? false : a(this).data("nav");
                var d = void 0 === a(this).data("duration") ? 4e3 : a(this).data("duration");
                a(this).owlCarousel({
                    rtl: THEMEMASCOT.isRTL.check(),
                    autoplay: true,
                    autoplayTimeout: d,
                    loop: true,
                    items: 6,
                    margin: 15,
                    dots: b,
                    nav: c,
                    navText: [ '<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>' ],
                    responsive: {
                        0: {
                            items: 1,
                            center: false
                        },
                        480: {
                            items: 1,
                            center: false
                        },
                        600: {
                            items: 2,
                            center: false
                        },
                        750: {
                            items: 3,
                            center: false
                        },
                        960: {
                            items: 4
                        },
                        1170: {
                            items: 6
                        },
                        1300: {
                            items: 6
                        }
                    }
                });
            });
            a(".owl-carousel-7col").each(function() {
                var b = void 0 === a(this).data("dots") ? false : a(this).data("dots");
                var c = void 0 === a(this).data("nav") ? false : a(this).data("nav");
                var d = void 0 === a(this).data("duration") ? 4e3 : a(this).data("duration");
                a(this).owlCarousel({
                    rtl: THEMEMASCOT.isRTL.check(),
                    autoplay: true,
                    autoplayTimeout: d,
                    loop: true,
                    items: 7,
                    margin: 15,
                    dots: b,
                    nav: c,
                    navText: [ '<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>' ],
                    responsive: {
                        0: {
                            items: 1,
                            center: false
                        },
                        600: {
                            items: 2,
                            center: false
                        },
                        750: {
                            items: 3,
                            center: false
                        },
                        960: {
                            items: 4
                        },
                        1170: {
                            items: 7
                        },
                        1300: {
                            items: 7
                        }
                    }
                });
            });
            a(".owl-carousel-8col").each(function() {
                var b = void 0 === a(this).data("dots") ? false : a(this).data("dots");
                var c = void 0 === a(this).data("nav") ? false : a(this).data("nav");
                var d = void 0 === a(this).data("duration") ? 4e3 : a(this).data("duration");
                a(this).owlCarousel({
                    rtl: THEMEMASCOT.isRTL.check(),
                    autoplay: true,
                    autoplayTimeout: d,
                    loop: true,
                    items: 8,
                    margin: 15,
                    dots: b,
                    nav: c,
                    navText: [ '<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>' ],
                    responsive: {
                        0: {
                            items: 1,
                            center: false
                        },
                        600: {
                            items: 2,
                            center: false
                        },
                        750: {
                            items: 3,
                            center: false
                        },
                        960: {
                            items: 5
                        },
                        1170: {
                            items: 8
                        },
                        1300: {
                            items: 8
                        }
                    }
                });
            });
        },
        TM_bxslider: function() {
            var b = a(".bxslider");
            if (b.length > 0) b.bxSlider({
                mode: "vertical",
                minSlides: void 0 === b.data("count") ? 2 : b.data("count"),
                slideMargin: 20,
                pager: false,
                prevText: '<i class="fa fa-angle-left"></i>',
                nextText: '<i class="fa fa-angle-right"></i>'
            });
        },
        TM_maximageSlider: function() {
            a("#maximage").maximage({
                cycleOptions: {
                    fx: "fade",
                    speed: 1500,
                    prev: ".img-prev",
                    next: ".img-next"
                }
            });
        }
    };
    THEMEMASCOT.documentOnReady = {
        init: function() {
            THEMEMASCOT.initialize.init();
            THEMEMASCOT.header.init();
            THEMEMASCOT.slider.init();
            THEMEMASCOT.widget.init();
            THEMEMASCOT.windowOnscroll.init();
        }
    };
    THEMEMASCOT.windowOnLoad = {
        init: function() {
            var a = setTimeout(function() {
                THEMEMASCOT.initialize.TM_wow();
                THEMEMASCOT.widget.TM_twittie();
                THEMEMASCOT.initialize.TM_magnificPopup_lightbox();
                THEMEMASCOT.initialize.TM_preLoaderOnLoad();
                THEMEMASCOT.initialize.TM_hashForwarding();
                THEMEMASCOT.initialize.TM_parallaxBgInit();
            }, 0);
            d.trigger("scroll");
            d.trigger("resize");
        }
    };
    THEMEMASCOT.windowOnscroll = {
        init: function() {
            d.on("scroll", function() {
                THEMEMASCOT.header.TM_scroolToTop();
                THEMEMASCOT.header.TM_activateMenuItemOnReach();
                THEMEMASCOT.header.TM_topnavAnimate();
            });
        }
    };
    THEMEMASCOT.windowOnResize = {
        init: function() {
            var a = setTimeout(function() {
                THEMEMASCOT.initialize.TM_equalHeightDivs();
                THEMEMASCOT.initialize.TM_resizeFullscreen();
            }, 400);
        }
    };
    b.ready(THEMEMASCOT.documentOnReady.init);
    d.on("load", THEMEMASCOT.windowOnLoad.init);
    d.on("resize", THEMEMASCOT.windowOnResize.init);
    THEMEMASCOT.initialize.TM_preLoaderClickDisable();
}(jQuery);

$(window).load(function() {
    $(".flexslider").flexslider({
        animation: "slide",
        slideshowSpeed: "2000",
        direction: "vertical"
    });
});